/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_BOOKS_H
#define INCLUDED_BOOKS_H


#include "libraries.h"


#define BOOKS_OT_FIRST_ID 1
#define BOOKS_OT_LAST_ID 39
#define BOOKS_NT_FIRST_ID 40
#define BOOKS_NT_LAST_ID 66


ustring books_filename (const ustring& project);
ustring books_filename_template ();

void books_create (const ustring& project);

void books_order (const ustring& project, vector<ustring>& books);

unsigned int books_name_to_id (const ustring& project, const ustring& book);
unsigned int books_paratext_to_id (const ustring& paratext);
unsigned int books_bibleworks_to_id (const ustring& bibleworks);
unsigned int books_osis_to_id (const ustring& osis);
unsigned int books_english_to_id (const ustring& english);
ustring books_id_to_name (const ustring& project, unsigned int id);
ustring books_id_to_paratext (unsigned int id);
ustring books_id_to_bibleworks (unsigned int id);
ustring books_id_to_osis (unsigned int id);
ustring books_id_to_english (unsigned int id);

void books_book_rename (const ustring& project, const ustring& oldname, const ustring& newname);


#endif
