/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_CHECK_COUNT_WORDS_H
#define INCLUDED_CHECK_COUNT_WORDS_H


#include "libraries.h"


class CheckCountWords
{
public:
  CheckCountWords (const ustring& project, const vector<ustring>& books, 
                   const ustring& extrachars,
                   bool sortword, bool sortcount, unsigned int excludecount, bool gui);
  vector<ustring> words;
  vector<unsigned int> counts;
  unsigned int total_count;
  unsigned int filtered_count;
  unsigned int total_unique_count;
  unsigned int filtered_unique_count;
private:
  void count (vector<ustring>& words);
  set <ustring> wordset;
  map <ustring, unsigned int> counter;
  vector <ustring> extra_character;
  vector <ustring> temporal_replacement;
};


#endif
