/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_CHECKS_H
#define INCLUDED_CHECKS_H


#include "libraries.h"
#include <gtk/gtk.h>


void checks_output_references_comments
     (const vector<ustring>& references, const vector<ustring>& comments);
void checks_display_references_comments
     (vector<ustring>& references, vector<ustring>& comments,
      GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn);
void checks_output_two_columns
     (const vector<ustring>& column1, const vector<unsigned int>& column2);

class DisplayCheckingResults
{
public:
  DisplayCheckingResults (const ustring& title);
  void word_inventory (const vector<ustring>& words, const vector<unsigned int>& count,
                       int total, int unique, int filteredtotal, int filteredunique,
                       int excludelimit);
private:
  vector <ustring> html;
  void start (const ustring& title);
  void heading (unsigned int level, const ustring& text);
  void paragraph (const ustring& text);
  void open_table ();
  void close_table ();
  void open_table_column ();
  void close_table_column ();
  void add_table_cell (const ustring& text, bool bold, bool right_aligned);
  void finalize ();
  ustring search_whole_words (const ustring& text, const ustring& word);
};

ustring get_non_alphanumericals (const ustring& s);


#endif
