/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogbook.h"
#include "utilities.h"
#include "bible.h"
#include "dialogselectchapters.h"
#include "projectutils.h"
#include "books.h"


enum { COLUMN_BOOK, COLUMN_EDITABLE, COLUMN_ID, NUM_COLUMNS };


BookDialog::BookDialog (const ustring& project)
{
  // Store data.
  myproject = project;

  bookdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (bookdialog), "Books");
  gtk_window_set_position (GTK_WINDOW (bookdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (bookdialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (bookdialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (bookdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  label11 = gtk_label_new ("To reorder a book, drag it to the new location.");
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (vbox1), label11, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);

/*
  label12 = gtk_label_new ("To rename a book, click on it and edit the name.");
  gtk_widget_show (label12);
  gtk_box_pack_start (GTK_BOX (vbox1), label12, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label12), 0, 0.5);
*/

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_IN);

  treeview1 = gtk_tree_view_new ();
  gtk_widget_show (treeview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), treeview1);
  gtk_widget_set_size_request (treeview1, -1, 400);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (treeview1), TRUE);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox8, TRUE, TRUE, 0);

  button_standard_order = gtk_button_new ();
  gtk_widget_show (button_standard_order);
  gtk_box_pack_start (GTK_BOX (hbox8), button_standard_order, FALSE, FALSE, 0);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (button_standard_order), alignment5);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox10);

  image5 = gtk_image_new_from_stock ("gtk-sort-ascending", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox10), image5, FALSE, FALSE, 0);

  label9 = gtk_label_new_with_mnemonic ("_Standard order");
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox10), label9, FALSE, FALSE, 0);

/*
  button_english_names = gtk_button_new ();
  gtk_widget_show (button_english_names);
  gtk_box_pack_start (GTK_BOX (hbox8), button_english_names, FALSE, FALSE, 0);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (button_english_names), alignment6);

  hbox9 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox9);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox9);

  image6 = gtk_image_new_from_stock ("gtk-clear", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox9), image6, FALSE, FALSE, 0);

  label10 = gtk_label_new_with_mnemonic ("_English names");
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox9), label10, FALSE, FALSE, 0);
*/

  dialog_action_area1 = GTK_DIALOG (bookdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (bookdialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (bookdialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
  
  g_signal_connect ((gpointer) button_standard_order, "clicked",
                    G_CALLBACK (on_button_standard_order_clicked),
                    gpointer(this));
/*
  g_signal_connect ((gpointer) button_english_names, "clicked",
                    G_CALLBACK (on_button_english_names_clicked),
                    gpointer(this));
*/                    
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_okbutton1_clicked),
                    gpointer(this));

  gtk_widget_grab_focus (treeview1);
  gtk_widget_grab_default (okbutton1);

  // Storage, renderer, column and selection.
  model = gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT);
  gtk_tree_view_set_model (GTK_TREE_VIEW (treeview1), GTK_TREE_MODEL (model));
  g_object_unref (model);
  GtkCellRenderer * renderer = gtk_cell_renderer_text_new ();
  g_signal_connect (renderer, "edited", G_CALLBACK (cell_edited), gpointer (this));
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview1), -1, 
    "Name", renderer, "text", COLUMN_BOOK, "editable", COLUMN_EDITABLE, NULL);
  gtk_tree_selection_set_mode (gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview1)), GTK_SELECTION_SINGLE);

  // Load content.
  vector <ustring> books = project_get_books (myproject);
  GtkTreeIter iter;
  for (unsigned int i = 0; i < books.size(); i++) {
    gtk_list_store_append (model, &iter);
    gint id = books_name_to_id (myproject, books[i]);
    gtk_list_store_set (model, &iter, COLUMN_BOOK, books[i].c_str (), COLUMN_EDITABLE, 0, COLUMN_ID, id, -1);
    // ( Set to "COLUMN_EDITABLE, 1" to make it editable).
  }
}


BookDialog::~BookDialog ()
{
  gtk_widget_destroy (bookdialog);
}


int BookDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (bookdialog));
}


void BookDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((BookDialog *) user_data)->on_okbutton ();
}


void BookDialog::on_okbutton ()
{
  // Get the model
  GtkTreeModel * model;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview1));
  // Some variables needed.
  GtkTreeIter iter;
  gboolean valid;
  gint index = 0;
  // Get the first iter in the store.
  valid = gtk_tree_model_get_iter_first (model, &iter);
  while (valid) {
    // Produce path.
    GtkTreePath * path = NULL;
    path = gtk_tree_path_new_from_indices (index, -1);
    // Read the row from the model.
    gchar *str_book;
    gint identifier;
    gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, COLUMN_BOOK, &str_book, COLUMN_ID, &identifier, -1);
// cout << books_id_to_name (myproject, identifier) << " is now named " << str_book << endl;
    // Free some data.
    gtk_tree_path_free (path);
    g_free (str_book);
    // Next row.
    valid = gtk_tree_model_iter_next (model, &iter);
    index++;
  }
}


void BookDialog::on_button_standard_order_clicked (GtkButton *button, gpointer user_data)
{
  ((BookDialog *) user_data)->on_button_standard_order ();
}


void BookDialog::on_button_standard_order ()
{
  // Get the model
  GtkTreeModel * model;
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (treeview1));
  // Get the selection.
  GtkTreeSelection * selection;
  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview1));
  // Go through all the Bible books.
  for (unsigned int i = BOOKS_OT_FIRST_ID; i <= BOOKS_NT_LAST_ID; i++) {
    // Get English bookname, e.g. Matthew.
    ustring book = books_id_to_english (i);
    // Some variables needed to iterate through the model.
    GtkTreeIter iter;
    gboolean valid;
    gint index = 0;
    // Get the first iter in the store.
    valid = gtk_tree_model_get_iter_first (model, &iter);
    // Go through the store.
    while (valid) {
      // Produce path.
      GtkTreePath * path = NULL;
      path = gtk_tree_path_new_from_indices (index, -1);
      // Read the row.
      gchar *str_data;
      gtk_tree_model_get (model, &iter, 0, &str_data, -1);
      // See if this is the book we wish to reorder.
      if (book == str_data) {
        // Move this one to the end of the store.
        gtk_list_store_move_before (GTK_LIST_STORE (model), &iter, NULL);
      }
      // Free some data.
      gtk_tree_path_free (path);
      g_free (str_data);
      // Next row.
      valid = gtk_tree_model_iter_next (model, &iter);
      index++;
    }
  }
}


void BookDialog::on_button_english_names_clicked (GtkButton *button, gpointer user_data)
{
  ((BookDialog *) user_data)->on_button_english_names ();
}


void BookDialog::on_button_english_names ()
{
  
}


void BookDialog::cell_edited (GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text, gpointer data)
{
  ((BookDialog *) data)->on_cell_edited (cell, path_string, new_text);
}


void BookDialog::on_cell_edited (GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text)
{
  return;
  // Set / initialize some variables.
  GtkTreeModel *tmodel = (GtkTreeModel *)model;
  GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
  GtkTreeIter iter;
  gtk_tree_model_get_iter (tmodel, &iter, path);
  // Free memory for the old text.
  gchar *old_text;
  gtk_tree_model_get (tmodel, &iter, COLUMN_BOOK, &old_text, -1);
  g_free (old_text);
  // Make copy of new text and put it in the store. 
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, COLUMN_BOOK, g_strdup (new_text), -1);
  // Free path.
  gtk_tree_path_free (path);
}
