/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <glib.h>
#include "dialogsynchronization.h"
#include "generalconfig.h"


SynchronizationDialog::SynchronizationDialog (int dummy)
{
  GeneralConfiguration configuration (0);
  
  synchronizationdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (synchronizationdialog), "Synchronization");
  gtk_window_set_type_hint (GTK_WINDOW (synchronizationdialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (synchronizationdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("Synchronize a project");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  checkbutton_project_open = gtk_check_button_new_with_mnemonic ("when opening the _project");
  gtk_widget_show (checkbutton_project_open);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_project_open, FALSE, FALSE, 0);

  // Set state.
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_project_open), configuration.synchronize_project_on_open());
  
  checkbutton_project_close = gtk_check_button_new_with_mnemonic ("when closing the p_roject");
  gtk_widget_show (checkbutton_project_close);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_project_close, FALSE, FALSE, 0);

  // Set state.
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_project_close), configuration.synchronize_project_on_close());
  
  hbox1 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  checkbutton_minutes = gtk_check_button_new_with_mnemonic ("_every");
  gtk_widget_show (checkbutton_minutes);
  gtk_box_pack_start (GTK_BOX (hbox1), checkbutton_minutes, FALSE, FALSE, 0);

  // Set state.
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_minutes), configuration.synchronize_project_regularly());

  spinbutton_minutes_adj = gtk_adjustment_new (1, 1, 800, 1, 10, 10);
  spinbutton_minutes = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_minutes_adj), 1, 0);
  gtk_widget_show (spinbutton_minutes);
  gtk_box_pack_start (GTK_BOX (hbox1), spinbutton_minutes, FALSE, TRUE, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbutton_minutes), TRUE);
  
  // Set value.
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinbutton_minutes), configuration.synchronize_project_minutes());

  label2 = gtk_label_new ("minutes");
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox1), label2, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, TRUE, TRUE, 0);

  label3 = gtk_label_new ("Synchronize all projects");
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (vbox1), label3, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

  checkbutton_startup = gtk_check_button_new_with_mnemonic ("on _startup");
  gtk_widget_show (checkbutton_startup);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_startup, FALSE, FALSE, 0);

  // Set state.
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_startup), configuration.synchronize_on_startup());

  checkbutton_shutdown = gtk_check_button_new_with_mnemonic ("on shut_down");
  gtk_widget_show (checkbutton_shutdown);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_shutdown, FALSE, FALSE, 0);

  // Set state.
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_shutdown), configuration.synchronize_on_shutdown());

  dialog_action_area1 = GTK_DIALOG (synchronizationdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (synchronizationdialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (synchronizationdialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect_after ((gpointer) checkbutton_minutes, "toggled",
                    G_CALLBACK (on_checkbutton_minutes_toggled),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_okbutton1_clicked),
                    gpointer(this));

  gtk_widget_grab_focus (okbutton1);
  gtk_widget_grab_default (okbutton1);
  
  // Update gui.
  on_checkbutton_minutes (false);
}


SynchronizationDialog::~SynchronizationDialog ()
{
  gtk_widget_destroy (synchronizationdialog);
}


int SynchronizationDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (synchronizationdialog));
}



void SynchronizationDialog::on_checkbutton_minutes_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  ((SynchronizationDialog *) user_data)->on_checkbutton_minutes (true);
}


void SynchronizationDialog::on_checkbutton_minutes (bool toggle)
{
  bool sync_regularly = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_minutes));
  gtk_widget_set_sensitive (spinbutton_minutes, sync_regularly);
  if (sync_regularly && toggle)
    gtk_widget_grab_focus (spinbutton_minutes);  
}


void SynchronizationDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((SynchronizationDialog *) user_data)->on_okbutton ();
}


void SynchronizationDialog::on_okbutton ()
{
  // Save values in the configuration.
  GeneralConfiguration configuration (0);
  configuration.synchronize_project_on_open_set(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_project_open)));
  configuration.synchronize_project_on_close_set(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_project_close)));
  configuration.synchronize_project_regularly_set(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_minutes)));
  configuration.synchronize_project_minutes_set((int)gtk_spin_button_get_value (GTK_SPIN_BUTTON (spinbutton_minutes)));
  configuration.synchronize_on_startup_set(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_startup)));
  configuration.synchronize_on_shutdown_set(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton_shutdown)));
}
