/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "gui.h"


void gui_okay (GtkWidget * image, GtkWidget * label, bool ok)
// Sets image and text in the GUI whether things are okay or not.
{
  if (ok) {
    gtk_image_set_from_stock (GTK_IMAGE (image), "gtk-yes", GTK_ICON_SIZE_BUTTON);
    gtk_label_set_text (GTK_LABEL (label), "Done:");
  } else {
    gtk_image_set_from_stock (GTK_IMAGE (image), "gtk-dialog-warning", GTK_ICON_SIZE_BUTTON);
    gtk_label_set_text (GTK_LABEL (label), "To do:");
  }
}
