/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_CHECK_COMPARE_USFMS_H
#define INCLUDED_CHECK_COMPARE_USFMS_H


#include "libraries.h"
#include "progresswindow.h"


class CheckCompareUsfms
{
public:
  CheckCompareUsfms (const ustring& project, const ustring& project2, 
                     const vector<unsigned int>& books, bool gui,
                     bool allmarkers, const ustring& includeonly, 
                     const ustring& ignore, bool ignoreverse0);
  ~CheckCompareUsfms ();
  vector<ustring> references;
  vector<ustring> comments;
private:
  ProgressWindow * progresswindow;
  ustring myproject;
  ustring myproject2;
  bool myallmarkers;
  set<ustring> myincludeonly;
  set<ustring> myignore;
  bool myignoreverse0;  
  void message (unsigned int book, unsigned int chapter, const ustring& verse, const ustring& message);
  void comparebook (unsigned int book);
  void comparechapter (unsigned int book, unsigned int chapter);
  void compareverse (unsigned int book, unsigned int chapter, const ustring& verse);
  void storemarker (const ustring& marker, ustring& markers, const ustring& verse);
};


#endif
