/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_OPENDOCUMENT_H
#define INCLUDED_OPENDOCUMENT_H


#include "libraries.h"
#include "generalconfig.h"
#include "projectconfig.h"
#include "usfm.h"
#include "progresswindow.h"
#include "odtutils.h"
#include "usfm-inline-markers.h"
#include "odtnotes.h"


class OpenDocument
{
public:
  OpenDocument (const ustring& project, const ustring& filename, bool gui);
  ~OpenDocument ();
private:
  GeneralConfiguration genconfig;
  ProjectConfiguration projectconfig;
  Usfm usfm;
  UsfmInlineMarkers * usfm_inline_markers;
  OdtFootnote * odtfootnote;
  OdtEndnote * odtendnote;
  OdtXref * odtxref;
  ProgressWindow * progresswindow;
  ustring workingdirectory;
  vector <unsigned int> books;
  vector<ustring> odtlines;
  OdtTextParagraph * odttextparagraph;
  ustring fontname;
  void get_template ();
  void cover ();
  void format_general (vector <ustring>& lines);
  void generate_styles (vector <ustring>& automaticstyles, vector <ustring>& styles);
  void zip (const ustring filename);
};


#endif
