#!../src/bltwish

package require BLT

# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------

if { $tcl_version >= 8.0 } {
    namespace import blt::*
    namespace import -force blt::tile::*
}

source scripts/demo.tcl

option add *Graph.Tile			bgTexture
option add *Label.Tile			bgTexture
option add *Frame.Tile			bgTexture
option add *Htext.Tile			bgTexture
option add *TileOffset			0

option add *HighlightThickness		0
#option add *shadow			orange2
#option add *titleColor			orange2


set visual [winfo screenvisual .] 
if { $visual != "staticgray" } {
    option add *print.background yellow
    option add *quit.background red
}

image create photo bgTexture -file ./images/buckskin.gif
set remote {}
set graph .graph

#option add *tile bgTexture
#option add *Postscript.Preview		yes
#option add *Postscript.Landscape	yes
#option add *Postscript.Maxpect		yes
#option add *Postscript.Center		yes

#option add *rotate -45
htext .header -text {\
This is an example of the graph widget.  It displays two-variable data 
with assorted line attributes and symbols.  To create a postscript file 
"xy.ps", press the %%
    button $htext(widget).print -text print -command {
        puts stderr [time {.graph postscript output xy.ps}]
    } 
    $htext(widget) append $htext(widget).print
%% button.}

source scripts/graph1.tcl

$graph postscript configure \
	-center yes -maxpect yes -landscape no -preview yes
$graph configure -bd 0 

htext .footer -text {Hit the %%
button $htext(widget).quit -text quit -command { 
    catch "send GraphConfig after 1 exit" 
    exit
} 

$htext(widget) append $htext(widget).quit 
%% button when you've seen enough.%%
label $htext(widget).logo -bitmap BLT
$htext(widget) append $htext(widget).logo -padx 20
%%}

scrollbar .xbar -command { .graph axis view x } -orient horizontal
scrollbar .ybar -command { .graph axis view y } -orient vertical
.graph axis configure x -scrollcommand { .xbar set } -logscale no -loose no
.graph axis configure y -scrollcommand { .ybar set } -logscale no  


$graph element bind all <Enter> {
    %W legend activate [%W element get current]
}

$graph element bind all <Leave> {
    %W legend deactivate [%W element get current]
}

$graph marker bind Text <B2-Motion> {
    set coords [%W invtransform %x %y]
    catch { %W marker configure [%W marker get current] -coords $coords }
}

$graph marker bind fred <Enter> {
    set marker [%W marker get current]
    catch { %W marker configure $marker -outline white -fill red}
}

$graph marker bind fred <Leave> {
    set marker [%W marker get current]
    catch { %W marker configure $marker -outline black -fill ""}
}

# $graph marker create polygon \
#     -coords { 0 200  1 300  2 200  3 200  4 300  5 200  } \
#     -name xPolygon -linewidth 0 \
#     -fill red -outline  blue 

$graph marker create text -bindtags "fred Text all" -name Test\
      -text "Move with\nmouse button #2" -coords "3.0 170.0" \
	-anchor center  -outline black -fill ""

if 0 {
set printer [printer open [lindex [printer names] 0]]
after 2000 {
	.graph print2 $printer
}
}

table . \
    0,0 .header -cspan 3 -fill x \
    1,0 .graph  -fill both -cspan 3 -rspan 3 \
    2,3 .ybar -fill y  -padx 0 -pady 0 \
    4,1 .xbar -fill x \
    5,0 .footer -cspan 3 -fill x

table configure . c3 r0 r4 r5 -resize none

$graph configure -leftvariable left 

trace variable left w "UpdateTable .graph"

proc UpdateTable { graph p1 p2 how } {
    table configure . c0 -width [$graph extents leftmargin]
    table configure . c2 -width [$graph extents rightmargin]
    table configure . r1 -height [$graph extents topmargin]
    table configure . r3 -height [$graph extents bottommargin]
}

.graph marker create line -name spot1 -xor yes -dashes 4 -linewidth 2
.graph marker create line -name spot2 -xor yes -dashes 4 -linewidth 2
.graph marker create polygon -name fill     

bind .graph <Shift-Motion> { 
    set x [.graph axis invtransform x %x]
    set y [.graph axis invtransform y %y]
    if { [.graph element closest %x %y info -interpolate yes -along y -halo 8i line2] } {
	.graph marker configure spot1 -coords "$x $y $info(x) $info(y)"
    }
    if { [.graph element closest %x %y info -interpolate yes -along x -halo 8i line2] } {
	.graph marker configure spot2 -coords "$x $y $info(x) $info(y)"
    }
}   
