/***************************************************************************
                          browserlist.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This is a place-holder for the BrowserList[] global array.  This      *
 *   contains information about each browser supported by BookmarkBridge.  *
 *                                                                         *
 ***************************************************************************/

#include "browserlist.h"
#include "bknode.h"
#include "iexplore.h"
#include "mozilla.h"
#include "opera.h"
#include "firebird.h"
#include "konqueror.h"

/***************************************************************************
 *                                                                         *
 *   IT IS VERY IMPORTANT TO NEVER REMOVE ELEMENTS FROM THIS LIST ! ! !    *
 *                                                                         *
 *   An element's position in this list determines its BRWSTYPE value.     *
 *   This value is saved in configuration files and used to figure out     *
 *   which browser class to use.                                           *
 *                                                                         *
 ***************************************************************************/

BROWSERLIST BrowserList[] = {
	{
		"Internet Explorer",
		IExplore::classFactory,
		IExplore::saveBookmarks
	},{
		"Mozilla Navigator",
		Mozilla::classFactory,
		Mozilla::saveBookmarks
	},{
		"Opera",
		Opera::classFactory,
		Opera::saveBookmarks
	},{
		"Mozilla Browser",
		Firebird::classFactory,
		Firebird::saveBookmarks
	},{
		"Konqueror",
		Konqueror::classFactory,
		Konqueror::saveBookmarks
	},{
		NULL,
		NULL,
		NULL
	}
};
