/***************************************************************************
                          dlgbrowsers.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

#include "dlgbrowsers.h"
#include "browserlist.h"

#include <qlistbox.h>

extern BROWSERLIST BrowserList[];

/***************************************************************************
 *                                                                         *
 *   The BrowserItem class (derived from QListBoxText) represents an item  *
 *   in the listbox of browsers supported by BookmarkBridge.  All it does  *
 *   is store the BrowserNum of the browser it represents.                 *
 *                                                                         *
 ***************************************************************************/
 
class BrowserItem : public QListBoxText
{
public:
	BrowserItem(QListBox *listbox=0, const QString &text=QString::null) :
		QListBoxText(listbox,text) { };

	BRWSTYPE browser;
};

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::DlgBrowsers()                                            *
 *                                                                         *
 *   Parameters:                                                           *
 *      QWidget *parent                                                    *
 *      const char *name                                                   *
 *      bool modal                                                         *
 *      WFlags f                                                           *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor                                                  *
 *                                                                         *
 ***************************************************************************/

DlgBrowsers::DlgBrowsers( QWidget* parent, const char* name, bool modal, WFlags f )
	: DlgBrowsersBase( parent, name, modal, f )
{
	browser = 0;
	RefreshList();
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::~DlgBrowsers()                                           *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class destructor                                                   *
 *                                                                         *
 ***************************************************************************/

DlgBrowsers::~DlgBrowsers()
{
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::RefreshList()                                            *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called to populate the list of browsers supported *
 *      by BookmarkBridge in a listbox.                                    *
 *                                                                         *
 ***************************************************************************/

void DlgBrowsers::RefreshList(void)
{
	int i;

	listBrowsers->clear();

	BrowserItem *item;

	for(i=0; ; i++)
	{
		if(BrowserList[i].Name==NULL || BrowserList[i].Factory==NULL)
			break;

		item = new BrowserItem(listBrowsers, BrowserList[i].Name);
		item->browser = i+1;
	}

	ASSERT(i > 0);
	listBrowsers->setCurrentItem(0);
}

/***************************************************************************
 *                                                                         *
 *   DlgBrowsers::listSelectionChanged()                                   *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function (actually a slot) is called by the Qt framework when *
 *      the user clicks somewhere in the browsers listbox.  It stores the  *
 *      BrowserNum of the selected item (or 0 if none selected).           *
 *                                                                         *
 ***************************************************************************/

void DlgBrowsers::listSelectionChanged(void)
{
	BrowserItem *item;

	browser = 0;

	int n = listBrowsers->currentItem();
	if(n < 0)
		return;

	item = static_cast<BrowserItem *>(listBrowsers->item(n));
	browser = item->browser;
}
