/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
--------------------------------------------------------------------*/
#include "Busy.h"
#include <qevent.h>
#include <qapplication.h>
#include <qeventloop.h>
#include <qcursor.h>

/*------- local variables:
--------------------------------------------------------------------*/
Busy* Busy::d_instance = 0;

//********************************************************************
// CBusy
//********************************************************************
Busy::Busy()
: QObject( 0 )
, d_isOn( FALSE )
{}
// end of CBusy

//********************************************************************
// set_busy
//********************************************************************
void Busy::set_busy( bool in_on )
{
	if( 0 == d_instance ) {
		d_instance = new Busy();
	}

	if( in_on != d_instance->d_isOn ) {
		if( TRUE == in_on ) {
			qApp->installEventFilter( d_instance );
			QApplication::setOverrideCursor( Qt::WaitCursor );
			QApplication::eventLoop()->processEvents( QEventLoop::AllEvents );
		}
		else {
			qApp->removeEventFilter( d_instance );
			QApplication::restoreOverrideCursor();
			QApplication::eventLoop()->processEvents( QEventLoop::AllEvents );
		}
		d_instance->d_isOn = in_on;
	}
}
// end of set_busy

//********************************************************************
// eventFilter
//********************************************************************
bool Busy::eventFilter( QObject*, QEvent* e )
{
	const QEvent::Type type = e->type();
	
	if(( QEvent::KeyPress == type ) || ( QEvent::KeyRelease == type )) {
		const QKeyEvent* const ke = dynamic_cast<QKeyEvent*>( e );
		return ( Qt::Key_Escape == ke->key() ) ? FALSE : TRUE;
	}
	
	return ( type == QEvent::MouseButtonPress || type == QEvent::MouseButtonRelease || type == QEvent::MouseButtonDblClick );
}
// end of eventFilter
