/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
// Created: 2005-05-08

#ifndef INCLUDED_MAINWINDOW_H
#define INCLUDED_MAINWINDOW_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QMAINWINDOW_H
#include <qmainwindow.h>
#define INCLUDED_QMAINWINDOW_H
#endif // INCLUDED_QMAINWINDOW_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QApplication;
class QAction;
class QPopupMenu;
class QToolBar;
class QStatusBar;
class QPushButton;
class QFrame;
class QTabBar;
class QWidgetStack;
class QSplitter;
class ViewWindow;
class Workspace;
class QTranslator;
class QTab;

/*------- class declaration:
-------------------------------------------------------------------*/
class MainWindow : public QMainWindow
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	MainWindow();
	~MainWindow();
private:
	MainWindow( const MainWindow& );
	MainWindow& operator=( const MainWindow& );

// ******* TYPES *******
public:
	enum
	{
		BTN_HELP = 0,
		BTN_ATTR,
		BTN_VIEW,
		BTN_EDIT,
		BTN_COPY,
		BTN_RENAME,
		BTN_MKDIR,
		BTN_DELETE,
		BTN_PACK,
		BTN_QUIT,
		BTN_NUMBER
	};
	
// ####### MEMBERS #######
private:
	static const char* const APP_ICON;
	static const char* const TabViewLabel;
	static const char* const TabConsoleLabel;
	static const char* const MenuSystemText;
	static const char* const MenuOperText;
	static const char* const MenuLangText;
	static const char* const MenuHelpText;
	static const char* const AboutQtMenuText;
	static const char* const AboutMenuText;
	static const char* const ReloadMenuText;
	static const char* const RELOAD_MENU_ICON;
	static const char* const FilterMenuText;
	static const char* const FILTER_MENU_ACCEL;
	static const char* const FILTER_MENU_ICON;
	static const char* const NcMenuText;
	static const char* const KdeMenuText;
	static const char* const SystemInfoMenuText;
	static const char* const SystemInfoIcon;
	static const char* const SwitchMenuText;
	static const char* const SwitchMenuIcon;
	static const char* const SwitchMenuAccel;
	static const char* const TabNewMenuText;
	static const char* const TabNewMenuIcon;
	static const char* const TabNewMenuAccel;
	static const char* const TabRemoveMenuText;
	static const char* const TabRemoveMenuIcon;
	static const char* const TabRemoveMenuAccel;
	static const char* const FileJoinMenuText;
	static const char* const FileJoinMenuIcon;
	static const char* const FileJoinMenuAccel;
	static const char* const TreeMenuText;
	static const char* const CmpFilesMenuText;
	static const char* const CMP_FILES_MENU_ICON;
	static const char* const CmpDirMenuText;
	static const char* const DirSynchIcon;
	static const char* const DirSynchMenuText;
	static const char* const DateTimeMenuText;
	static const char* const DATETIME_MENU_ICON;
	static const char* const SelectMenuText;
	static const char* const SELECT_MENU_ICON;
	static const char* const UnselectMenuText;
	static const char* const UNSELECT_MENU_ICON;
	static const char* const ReversMenuText;
	static const char* const REVERS_MENU_ICON;
	static const char* const Md5CreateAccel;
	static const char* const Md5CreateMenuText;
	static const char* const Md5CheckAccel;
	static const char* const Md5CheckMenuText;
	static const char* const FtpStartMenuText;
	static const char* const FTP_START_MENU_ICON;
	static const char* const FtpEndMenuText;
	static const char* const FTP_END_MENU_ICON;
	static const char* const ConfigureMenuText;
	static const char* const CONFIGURE_MENU_ICON;
	static const char* const ExitMenuText;
	static const char* const EXIT_MENU_ACCEL;
	static const char* const EXIT_MENU_ICON;
	static const char* const LANG_EN_MENU_TEXT;
	static const char* const LANG_RU_MENU_TEXT;	
	static const char* const LANG_PL_MENU_TEXT;
	static const char* const LANG_DE_MENU_TEXT;
	static const char* const LANG_ES_MENU_TEXT;
	static const char* const LANG_CS_MENU_TEXT;
	static const char* const CONFIG_GROUP_NAME;
	static const char* const CONFIG_KEY_WIDTH;
	static const char* const CONFIG_KEY_HEIGHT;

	QAction*    const d_action_about_qt;
	QAction*    const d_action_about;
	QAction*    const d_action_reload;
	QAction*    const d_action_filter;
	QAction*    const d_action_nc;
	QAction*    const d_action_kde;
	QAction*    const d_action_exit;
	QAction*    const d_action_system_info;
	QAction*    const d_action_switch;
	QAction*    const d_action_tab_new;
	QAction*    const d_action_tab_remove;
	QAction*    const d_action_joinfiles;
	QAction*    const d_action_tree;
	QAction*    const d_action_cmp_files;
	QAction*    const d_action_cmp_dirs;
	QAction*    const d_action_dir_synch;
	QAction*    const d_action_datetime;
	QAction*    const d_action_select;
	QAction*    const d_action_unselect;
	QAction*    const d_action_revers;
	QAction*    const d_action_md5_create;
	QAction*    const d_action_md5_check;
	QAction*    const d_action_ftp_start;
	QAction*    const d_action_configure;
	QAction*    const d_action_ftp_end;
	QAction*    const d_action_lang_en;
	QAction*    const d_action_lang_ru;	
	QAction*    const d_action_lang_pl;
	QAction*    const d_action_lang_de;
	QAction*    const d_action_lang_es;
	QAction*    const d_action_lang_cs;
	QPopupMenu* const d_popup_system;
	QPopupMenu* const d_popup_oper;
	QPopupMenu* const d_popup_lang;
	QPopupMenu* const d_popup_help;
	QToolBar*   const d_tool_bar;
	QTranslator* const d_translator;
	QPushButton*      d_function_buttons[BTN_NUMBER];
	Workspace*        d_workspace;
	bool              d_lang_doit;
	bool              d_selection_doit;

// ####### METHODS #######
private:
	void create_actions         ();
	void init_tool_bar          ();
	void init_menu              ( bool );
	void init_popup_system_menu ();
	void init_popup_oper_menu   ();
	void init_popup_lang_menu   ();
	void init_popup_help_menu   ();
	void create_button_area     ( QFrame* const parent );
	void read_settings          ();
	void write_settings         ();
	void polish                 ();
	void keyPressEvent          ( QKeyEvent* e );
	void closeEvent             ( QCloseEvent* e );
	void read_lang_info         ();
	void update_lang            ( bool = FALSE );
	void retranslate_strings    ( bool );
// ####### SLOTS #######
private slots:
	void F1                   ();
	void F10                  ();
	void about                ();
	void slot_ftp_start       ();
	void lang_en              ( bool );
	void lang_ru              ( bool );	
	void lang_pl              ( bool );
	void lang_de              ( bool );
	void lang_es              ( bool );
	void lang_cs              ( bool );
	void nc_selection         ( bool );
	void kde_selection        ( bool );
	void redraw_buttons       ();
	void system_info          ();
public slots:
	void ftp_end_handle       ();
signals:
	void ftp_start            ();
	void ftp_end              ();
	void lang_changed         ();
	void selection_changed    ();
};

#endif // INCLUDED_MAINWINDOW_H
