/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BSCommander; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_STARTDIR_H
#define INCLUDED_STARTDIR_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QGroupBox;
class QPushButton;
class QCheckBox;
class QLineEdit;
class QComboBox;

/*------- class declaration:
-------------------------------------------------------------------*/
class StartDir : public QDialog
{
	Q_OBJECT
public:
	StartDir( QWidget* );
private:
	StartDir( const StartDir& );
	StartDir& operator=( const StartDir& );

// ******* CONSTANTS *******
private:
	static const QString Caption;
	static const QString RootDirTitle;
	static const QString HomeDirTitle;
	static const QString SelectDirTitle;
	static const QString EditDirTitle;
	static const QString SelectLabel;

// ******* MEMBERS *******
private:
	QGroupBox*   const d_root_gbox;
	QGroupBox*   const d_home_gbox;
	QGroupBox*   const d_select_gbox;
	QGroupBox*   const d_edit_gbox;
	QCheckBox*   const d_root_cb;
	QCheckBox*   const d_home_cb;
	QCheckBox*   const d_select_cb;
	QCheckBox*   const d_edit_cb;
	QComboBox*   const d_selector;
	QLineEdit*   const d_edit;
	QPushButton* const d_select_btn;
	QPushButton* const d_return_btn;
	bool               d_wait;

// ******* METHODS *******
public:
	void get_from_dir( QString& );
private:
	void deselect_all();
private slots:
	void slot_select();
	void slot_return();
	void slot_root( bool );
	void slot_home( bool );
	void slot_select( bool );
	void slot_edit( bool );
};

#endif // INCLUDED_STARTDIR_H
