/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project: Beesoft Commander
 * Author : Piotr Pszczolkowski
 * Contact: piotr@beesoft.org
 *******************************************************************/
#ifndef INCLUDED_VIEWGENERIC_H
#define INCLUDED_VIEWGENERIC_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

#ifndef INCLUDED_QWIDGETSTACK_H
#include <qwidgetstack.h>
#define INCLUDED_QWIDGETSTACK_H
#endif // INCLUDED_QWIDGETSTACK_H

#ifndef INCLUDED_VIEWWINDOW_H
#include "ViewWindow.h"
#endif //INCLUDED_VIEWWINDOW_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class Workspace;
class QVBoxLayout;
class QTabBar;

/*------- class declaration:
-------------------------------------------------------------------*/
class ViewGeneric : public QFrame
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	ViewGeneric( QWidget* const in_parent, Workspace* const in_workspace );
private:
	ViewGeneric( const ViewGeneric& );
	ViewGeneric& operator=( const ViewGeneric& );

// ******* MEMBERS *******
protected:
	Workspace*    const d_workspace;
	QVBoxLayout*  const d_main_layout;
	QTabBar*      const d_tab_bar;
	QWidgetStack* const d_widget_stack;
	
// ******* METHODS *******
public:
	bool has_focus();
protected:
	ViewWindow* current_view();
	void set_tab           ( int );
	ViewWindow* new_tab    ( const QString&, int& );
	int  remove_tab        ();
protected slots:
	void slot_tab_update   ( const QString& );
	void slot_looks_refresh();
	void slot_update_lang  ();
signals:
	void F5();
	void F9();
	void disconnect_signals();
};

//*******************************************************************
// current_view                                              PRIVATE
//*******************************************************************
inline ViewWindow* ViewGeneric::current_view() 
{
	return	( d_widget_stack )
				? dynamic_cast<ViewWindow*>( d_widget_stack->visibleWidget() )
				: 0;
}
// end of current_view

#endif // INCLUDED_VIEWGENERIC_H
