/* Battle Tanks Game
 * Copyright (C) 2006-2007 Battle Tanks team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "mortar.h"
#include "mrt/exception.h"
#include "registrar.h"
#include "config.h"

#include "ai/buratino.h" 

class AIMortar:  public Mortar, public ai::Buratino {
public: 
	AIMortar(const std::string &classname) : Mortar(classname) {}
//	~AIMortar();
	virtual void onSpawn();
	virtual void calculate(const float dt);

	virtual Object * clone() const { return new AIMortar(*this); }

	virtual const std::string getWeapon(const int idx) const;
	virtual const int getWeaponAmount(const int idx) const;
private: 

};

const std::string AIMortar::getWeapon(const int idx) const {
	switch(idx) {
	case 0: 
		return "bullets:mortar";
	case 1:
		return std::string();
	default: 
		throw_ex(("weapon %d doesnt supported", idx));
	}
}

const int AIMortar::getWeaponAmount(const int idx) const{
	switch(idx) {
	case 0: 
		return -1;
	case 1:
		return 0;
	default: 
		throw_ex(("weapon %d doesnt supported", idx));
	}
}


void AIMortar::onSpawn() {
	addEnemyClass("fighting-vehicle");
	addEnemyClass("trooper");
	addEnemyClass("kamikaze");
	addEnemyClass("boat");
	addEnemyClass("helicopter");
	addEnemyClass("watchtower");
	addEnemyClass("barrack");
	addEnemyClass("monster"); //sandworm too
	
	addBonusName("heal");
	addBonusName("megaheal");
	
	addBonusName("teleport");

	ai::Buratino::onSpawn(this);
	Mortar::onSpawn();
}

void AIMortar::calculate(const float dt) {
	ai::Buratino::calculate(this, dt);
	
	GET_CONFIG_VALUE("objects.mortar.rotation-time", float, rt, 0.1);
	limitRotation(dt, rt, true, false);
	updateStateFromVelocity();	
}

REGISTER_OBJECT("mortar", AIMortar, ("fighting-vehicle"));
REGISTER_OBJECT("static-mortar", AIMortar, ("vehicle"));
