/*
 * Folder list widget
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include "FolderList.h"

#include <map>

#include <sigc++/sigc++.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelfilter.h>

#include "Environment.h"

using namespace std;

/*
void FolderList::on_filter_changed()
{
	filter = filterEdit.get_text();
	updateList();
}

void FolderList::on_document_changed()
{
	updateList();
}

void FolderList::on_add_tag(Tag tag)
{
	Glib::RefPtr<Gtk::TreeSelection> sel = itemList.get_selection();
	
	// Build the list of selected items
	selected.clear();

	Gtk::TreeSelection::ListHandle_Path lhp = sel->get_selected_rows();
	for (Gtk::TreeSelection::ListHandle_Path::const_iterator i = lhp.begin(); i != lhp.end(); i++)
	{
		Gtk::TreeModel::Row row = *itemListModel->get_iter(*i);
		Glib::ustring s = row[itemListModelColumns.name];
		selected.push_back(s);
	}

	// Build the Change
	TagcollChange<string, Tag> change;
	for (vector<string>::const_iterator i = selected.begin();
			i != selected.end(); i++)
	{
		TagSet ts = doc.collection().getTagsetForFolder(*i);
		change.insert(make_pair(*i, ts + tag));
	}

	// Post the change
	do_signal_request_tagcoll_change(change);
}

void FolderList::on_remove_tag(Tag tag)
{
	Glib::RefPtr<Gtk::TreeSelection> sel = itemList.get_selection();
	
	// Build the list of selected items
	selected.clear();

	Gtk::TreeSelection::ListHandle_Path lhp = sel->get_selected_rows();
	for (Gtk::TreeSelection::ListHandle_Path::const_iterator i = lhp.begin(); i != lhp.end(); i++)
	{
		Gtk::TreeModel::Row row = *itemListModel->get_iter(*i);
		Glib::ustring s = row[itemListModelColumns.name];
		selected.push_back(s);
	}
	
	// Build the Change
	TagcollChange<string, Tag> change;
	for (vector<string>::const_iterator i = selected.begin();
			i != selected.end(); i++)
	{
		TagSet ts = doc.collection().getTagsetForFolder(*i);
		change.insert(make_pair(*i, ts - tag));
	}

	// Post the change
	do_signal_request_tagcoll_change(change);
}

void FolderList::do_signal_request_tagcoll_change(TagcollChange<string, Tag> change)
{
	signal_request_tagcoll_change().emit(change);
}

void FolderList::do_signal_request_tagset_merge()
{
	signal_request_tagset_merge().emit();
}

void FolderList::do_signal_request_tagset_intersect()
{
	signal_request_tagset_intersect().emit();
}

void FolderList::do_signal_request_item_copy()
{
	signal_request_item_copy().emit();
}

void FolderList::do_signal_request_item_move()
{
	signal_request_item_move().emit();
}

void FolderList::do_signal_select_tagset(TagSet tagset)
{
	//debug("SRTA %.*s %.*s\n", PFSTR(item), PFSTR(tag));
	signal_select_tagset().emit(tagset);
}

void FolderList::do_signal_select_tagset_other_panel(TagSet tagset)
{
	//debug("SRTA %.*s %.*s\n", PFSTR(item), PFSTR(tag));
	signal_select_tagset_other_panel().emit(tagset);
}
*/

bool FolderList::on_event(GdkEvent* e)
{
	if (e->type == GDK_BUTTON_PRESS && e->button.button > 1)
	{
		Gtk::TreeModel::Path path;
		Gtk::TreeViewColumn* column;
		int cell_x, cell_y;
		if (folderList.get_path_at_pos(
				(int)e->button.x, (int)e->button.y,
				path, column,
				cell_x, cell_y))
		{
			// Clicked on an item
			debug("Cell %d, %d\n", cell_x, cell_y);

			Gtk::TreeModel::Row row = *folderListModel->get_iter(path);
			MailFolder folder = row[folderListModelColumns.folder];
			verbose("Clicked on %.*s\n", PFSTR(folder.path()));

			folderList.get_selection()->select(row);

			/*
			Glib::ustring tag = row[itemListModelColumns.name];
			TagSet ts = row[itemListModelColumns.tags];
			
			debug("Name: %.*s, %d tags\n", PFSTR(tag), ts.size());

			Glib::RefPtr<Gtk::TreeSelection> sel = itemList.get_selection();
			int rows = sel->count_selected_rows();

			itemPopup.items().clear();

			if (rows == 1)
			{
				itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Select this tag set",
							sigc::bind< TagSet >(
								sigc::mem_fun(*this, &FolderList::do_signal_select_tagset), ts)));
				itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Select this tag set in the other panel",
							sigc::bind< TagSet >(
								sigc::mem_fun(*this, &FolderList::do_signal_select_tagset_other_panel), ts)));
			}
			else
			{
				itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Merge",
							sigc::mem_fun(*this, &FolderList::do_signal_request_tagset_merge)));
				itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Intersect",
							sigc::mem_fun(*this, &FolderList::do_signal_request_tagset_intersect)));
			}
			itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Copy to other panel",
						sigc::mem_fun(*this, &FolderList::do_signal_request_item_copy)));
			itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Move to other panel",
						sigc::mem_fun(*this, &FolderList::do_signal_request_item_move)));

			TagMenu<TagcollDocument<string> >* addMenu = new TagMenu<TagcollDocument<string> >();
			addMenu->set_manage();
			addMenu->populateUnselected(doc, ts);
			string stag = tag;
			addMenu->signal_selected().connect(
						sigc::mem_fun(*this, &FolderList::on_add_tag));
			itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("_Add...", *addMenu));
	
			if (!ts.empty())
			{
				itemPopup.items().push_back(Gtk::Menu_Helpers::SeparatorElem());
				for (TagSet::const_iterator i = ts.begin();
						i != ts.end(); i++)
					itemPopup.items().push_back(Gtk::Menu_Helpers::MenuElem("Remove " + i->fullname(),
						sigc::bind<Tag>(
							sigc::mem_fun(*this, &FolderList::on_remove_tag), *i)));
			}

			itemPopup.popup(e->button.button, e->button.time);

			//printf("Menu finished\n");

			//delete addMenu;
			*/
			return true;
		} else {
			// Clicked outside
			warning("itemList.get_path_at_pos failed\n");
			return false;
		}
	}
	return false;
}

void FolderList::on_row_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn*)
{
	if(const Gtk::TreeIter iter = folderList.get_model()->get_iter(path))
	{
		Gtk::TreeModel::Row row = *iter;
		MailFolder folder = row[folderListModelColumns.folder];
		signal_open_folder().emit(folder);
		/*
		warning("Activated %.*s\n", PFSTR(folder.path()));
		string cmdline = "x-terminal-emulator -e mutt -f " + folder.path();
		try {
			warning("Running: %.*s\n", PFSTR(cmdline));
			Environment::get().spawnCommand(cmdline);
		} catch (SystemException& e) {
			warning("%s: %.*s\n", e.type(), PFSTR(e.desc()));
		}
		*/
	}
}

bool FolderList::filter_row(const Gtk::TreeModel::const_iterator& iter)
{
	// Hide empty folders
	Gtk::TreeModel::Row row = *iter;

	if (row[folderListModelColumns.msg_unread] > 0)
		return true;

	if (viewImportant && row[folderListModelColumns.msg_flagged] > 0)
		return true;

	if (viewRead && row[folderListModelColumns.msg_total] > 0)
		return true;

	return viewEmpty;

}


FolderList::FolderList()
	: viewEmpty(true), viewRead(true)
{
	// Add the TreeView, inside a ScrolledWindow
	scrolledFolderList.add(folderList);

	// Only show the scrollbars when they are necessary:
	scrolledFolderList.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);

	pack_start(scrolledFolderList, Gtk::PACK_EXPAND_WIDGET);

	// Create the Tree model
	folderListModel = Gtk::ListStore::create(folderListModelColumns);

	filteredModel = Gtk::TreeModelFilter::create(
			folderListModel,
			folderListModel->get_path(folderListModel->children().begin()));
	filteredModel->set_visible_func(sigc::mem_fun(*this, &FolderList::filter_row));

	sortedModel = Gtk::TreeModelSort::create(
			filteredModel);

	//folderList.set_model(folderListModel);
	//folderList.set_model(filteredModel);
	folderList.set_model(sortedModel);


	// Add the view columns
	Gtk::TreeViewColumn* column;
	int count;

	count = folderList.append_column("Name", folderListModelColumns.name);
	column = folderList.get_column(count - 1);
	column->set_sort_column(folderListModelColumns.name);
	
	count = folderList.append_column("New", folderListModelColumns.msg_new);
	column = folderList.get_column(count - 1);
	column->set_sort_column(folderListModelColumns.msg_new);

	count = folderList.append_column("Unread", folderListModelColumns.msg_unread);
	column = folderList.get_column(count - 1);
	column->set_sort_column(folderListModelColumns.msg_unread);

	count = folderList.append_column("Total", folderListModelColumns.msg_total);
	column = folderList.get_column(count - 1);
	column->set_sort_column(folderListModelColumns.msg_total);

	count = folderList.append_column("Flagged", folderListModelColumns.msg_flagged);
	column = folderList.get_column(count - 1);
	column->set_sort_column(folderListModelColumns.msg_flagged);

	/*
	folderList.get_column(0)->set_resizable(true);
	folderList.get_column(1)->set_resizable(true);
	*/

	Glib::RefPtr<Gtk::TreeSelection> folderListSelection = folderList.get_selection();
	folderListSelection->set_mode(Gtk::SELECTION_SINGLE);
	
	folderList.add_events(Gdk::BUTTON_PRESS_MASK);
	folderList.signal_event().connect(sigc::mem_fun(*this, &FolderList::on_event));
	folderList.signal_row_activated().connect(sigc::mem_fun(*this, &FolderList::on_row_activated));

	// Fill the list
	//updateList();
	
	/*
	folderList.signal_focus_in_event().connect(sigc::mem_fun(*this, &FolderList::on_focus_in));
	filterEdit.signal_changed().connect(sigc::mem_fun(*this, &FolderList::on_filter_changed));
	doc.signal_changed().connect(sigc::mem_fun(*this, &FolderList::on_document_changed));
	*/
}

void FolderList::consume(MailFolder& folder)
{
	Gtk::TreeModel::Row row = *(folderListModel->append());
	row[folderListModelColumns.folder] = folder;
	row[folderListModelColumns.name] = folder.name();

	//int msg_total, msg_unread, msg_new, msg_flagged;
	//folder.computeStatistics(&msg_total, &msg_unread, &msg_new, &msg_flagged);
	if (folder.changed())
	{
		folder.updateStatistics();

		row[folderListModelColumns.msg_new] = folder.getMsgNew();
		row[folderListModelColumns.msg_unread] = folder.getMsgUnread();
		row[folderListModelColumns.msg_total] = folder.getMsgTotal();
		row[folderListModelColumns.msg_flagged] = folder.getMsgFlagged();
	}
}

void FolderList::clear()
{
	folderListModel->clear();
}
	
void FolderList::do_update()
{
	debug("FolderList::do_update\n");
	for (Gtk::TreeModel::Children::const_iterator i = folderListModel->children().begin();
			i != folderListModel->children().end(); i++)
	{
		Gtk::TreeModel::Row row = *i;
		MailFolder folder = row[folderListModelColumns.folder];
		//row[folderListModelColumns.name] = folder.name();

		folder.updateStatistics();

		row[folderListModelColumns.msg_new] = folder.getMsgNew();
		row[folderListModelColumns.msg_unread] = folder.getMsgUnread();
		row[folderListModelColumns.msg_total] = folder.getMsgTotal();
		row[folderListModelColumns.msg_flagged] = folder.getMsgFlagged();
	}
}

bool FolderList::do_timer_tick()
{
	do_update();
	return true;
}

void FolderList::configureFilter(bool viewEmpty, bool viewRead, bool viewImportant)
{
	this->viewEmpty = viewEmpty;
	this->viewRead = viewRead;
	this->viewImportant = viewImportant;
	filteredModel->refilter();
}


/*
void FolderList::on_itemList_drag_data_get(
		const Glib::RefPtr<Gdk::DragContext>&, Gtk::SelectionData& selection_data, guint, guint)
{
	std::map<std::string, TagSet > sel = getSelection();
	if (sel.size())
	{
		Glib::ustring str;
		for (std::map< string, TagSet >::const_iterator i = sel.begin();
				i != sel.end(); i++)
		{
			str += i->first;

			for (TagSet::const_iterator j = i->second.begin();
					j != i->second.end(); j++)
			if (j == i->second.begin())
				str += ": " + j->fullname();
			else
				str += ", " + j->fullname();

			str += "\n";
		}
		
		selection_data.set(selection_data.get_target(), 8, (const guchar*)str.data(), str.size());
	}
}

void FolderList::on_itemList_drop_drag_data_received(
		const Glib::RefPtr<Gdk::DragContext>& context, int, int, const Gtk::SelectionData& selection_data, guint, guint time)
{
	if ((selection_data.get_length() >= 0) && (selection_data.get_format() == 8))
	{
		string type = selection_data.get_data_type();
		warning("Type: %.*s\n", PFSTR(type));
		Glib::ustring data((const char*)selection_data.get_data(), selection_data.get_length());
		Tag tag = doc.vocabulary().findTag(data);
		warning("Received: %.*s [%sfound in vocabulary]\n", PFSTR(data), tag ? "" : "not ");

		if (type == "TAG" && tag)
		{
			std::map< std::string, TagSet > sel = getSelection();

			TagcollChange<string, Tag> change;
			
			for (std::map< string, TagSet >::const_iterator i = sel.begin();
					i != sel.end(); i++)
				change.insert(make_pair(i->first, i->second + tag));
			
			doc.applyChange(change);
		}
		else if (type == "TAGCOLL")
		{
		}
	}

	context->drag_finish(false, false, time);
}



void FolderList::updateList()
{
	time_t start = time(NULL);

	std::map< std::string, TagSet > sel = getSelection();
	
	if (_tagset.empty())
	{
		OpSet<string> items = doc.collection().getUntaggedFolders();

		Gtk::TreeModel::Row row;
		itemListModel->clear();
		for (OpSet<string>::const_iterator i = items.begin(); i != items.end(); i++)
		{
			if (filter.empty() || i->find(filter) != string::npos)
			{
				row = *(itemListModel->append());
				row[itemListModelColumns.name] = *i;
				row[itemListModelColumns.tags] = TagSet();
				if (sel.find(*i) != sel.end())
					itemList.get_selection()->select(row);
			}
		}
	} else {
		std::map< string, OpSet<Tag> > items = doc.collection().getCompanionFoldersAndTagsets(_tagset);

		Gtk::TreeModel::Row row;
		itemListModel->clear();
		for (std::map< string, OpSet<Tag> >::const_iterator i = items.begin(); i != items.end(); i++)
		{
			if (filter.empty() || i->first.find(filter) != string::npos)
			{
				row = *(itemListModel->append());
				row[itemListModelColumns.name] = i->first;
				row[itemListModelColumns.tags] = i->second;
				if (sel.find(i->first) != sel.end())
					itemList.get_selection()->select(row);
			}
		}
	}

	time_t end = time(NULL);
	if (end != start)
		fprintf(stderr, "FolderList::updateList: %d seconds\n", (end-start));
}

map< string, TagSet > FolderList::getAllFolders()
{
	std::map< string, TagSet > res;

	for (Gtk::TreeModel::Children::const_iterator i = itemListModel->children().begin();
			i != itemListModel->children().end(); i++)
	{
		Gtk::TreeModel::Row row = *i;
		Glib::ustring s = row[itemListModelColumns.name];
		TagSet ts = row[itemListModelColumns.tags];
		res.insert(make_pair(s, ts));
		debug("Found: %.*s\n", PFSTR(s));
	}

	return res;
}

map< string, TagSet > FolderList::getSelection()
{
	Glib::RefPtr<Gtk::TreeSelection> itemSelection = itemList.get_selection();
	Gtk::TreeSelection::ListHandle_Path lhp = itemSelection->get_selected_rows();
	std::map< string, TagSet > res;

	for (Gtk::TreeSelection::ListHandle_Path::const_iterator i = lhp.begin(); i != lhp.end(); i++)
	{
		Gtk::TreeModel::Row row = *itemListModel->get_iter(*i);
		Glib::ustring s = row[itemListModelColumns.name];
		TagSet ts = row[itemListModelColumns.tags];
		res.insert(make_pair(s, ts));
	}

	return res;

	/ *
	FolderListSelectionDataGatherer data(*this);
	itemSelection->selected_foreach(sigc::slot(data, &FolderListSelectionDataGatherer::selected_row_callback));
	* /
	//return data.data();
}

int FolderList::getSelectionSize()
{
	Glib::RefPtr<Gtk::TreeSelection> itemSelection = itemList.get_selection();
	return itemSelection->count_selected_rows();
}

void FolderList::do_selection_changed()
{
	signal_selection_changed().emit();
}

void FolderList::do_focus_in()
{
	signal_focus_in().emit();
}

bool FolderList::on_focus_in(GdkEventFocus*)
{
	//debug("FOCUS IN\n");
	do_focus_in();
	return false;
}
*/

// vim:set ts=4 sw=4:
