/* Small tool to dump information about your Video devices */

#include <stdio.h>

#include "devices/VideoCollector.h"

int main(int argc, char *argv[])
{
   CVideoCollector *vcoll = CVideoCollector::Instance();
   CVideoDevice *vd;
   CVideoDeviceInput *vdi;
   CVideoDeviceTuner *vdt;
   int dev, inp, tun;
   int i, j, k;
   QSize sz;

   dev = vcoll->NumberOfVideoDevices();
   printf("Detected %d Video4Linux devices.\n", dev);
   for (i = 0; i < dev; i++) {
      vd = vcoll->GetVideoDevice(i);
      printf("Device node      : %s\n", (const char *)vd->GetNodeName());
      printf("Name of device   : \"%s\"\n", (const char *)vd->GetIntfName());
      sz = vd->GetMinSize();
      printf("Minimum size     : %dx%d\n", sz.width(), sz.height());
      sz = vd->GetSize();
      printf("Current size     : %dx%d\n", sz.width(), sz.height());
      sz = vd->GetMaxSize();
      printf("Maximum size     : %dx%d\n", sz.width(), sz.height());
      
      inp = vd->GetInputs();
      printf("Inputs           : %d\n", inp);
      for (j = 0; j < inp; j++) {
         vdi = vd->GetInput(j);
         printf("Input %d\n", j);
         printf("  Name             : \"%s\"\n", (const char *)vdi->GetName());
         switch(vdi->GetType()) {
           case CVideoDeviceInput::Unknown: printf("  Type             : Unknown\n"); break;
           case CVideoDeviceInput::TV:      printf("  Type             : TV\n"); break;
           case CVideoDeviceInput::Camera:  printf("  Type             : Camera\n"); break;
         }
         printf("  Audio            : %s\n", vdi->HasAudio() ? "yes" : "no");
         tun = vdi->GetTuners();
         printf("  Tuners           : %d\n", tun);
         for (k = 0; k < tun; k++) {
            vdt = vdi->GetTuner(k);
            printf("    Name             : \"%s\"\n", (const char *)vdt->GetName());
            printf("    Frequency range  : %6.2f-%6.2f MHz\n", vdt->GetLowestFrequency() / 1.0e6, vdt->GetHighestFrequency() / 1.0e6);
            printf("    Current frequency: %6.2f MHz\n", vdt->GetFrequency() / 1.0e6);
         }
      }
      
      printf("\n");
   }
   return 0;
}

