/* For debugging the various program modules. 
   
   All variables start with TRACE_; use a level to determine how much is 
   logged; 0 is minimal (or no) logging, higher numbers should log more.

   To enable tracing, #define ENABLE_TRACING in the file that you want to 
   trace, before you include "config.h" or "debug.h".
   
   Use the macro like this:
   
   Trace(CONFIGFILE, 3, "Opening log file");
   
   This message will only be printed if TRACE_CONFIGFILE is >= 3, i.e. very
   verbose. A newline is automatically appended.

 */

#ifdef ENABLE_TRACING
#undef Trace
#define Trace(what, level, string...) \
	if (TRACE_##what >= ##level) { \
		fprintf(stderr, ##string); \
		fprintf(stderr, "\n"); \
	}
#else
#undef Trace
#define Trace(what, level, string...) /* nop */
#endif


#define TRACE_CONFIGFILE	1

#define TRACE_PANELREG		1
#define TRACE_PANELPOS		1
#define TRACE_PANELSIGNALS	1

// CamCanvas.cc
#define TRACE_CANVAS_OPEN	1

// VideoCollector.cc
/* #define TRACE_VIDEOCOLLECTOR 1 */
#undef TRACE_VIDEOCOLLECTOR

// VideoDevice.cc
#undef TRACE_VIDEODEV_READ
#define TRACE_VIDEODEV_OPEN 1
#define TRACE_VIDEODEV_IOCTL 1


/* 'Philips Control' dialog */
#define TRACE_PHCONTROL_DLG	2

/* FTP */
#define TRACE_FTP 		2

/* VideoOptions */
#define TRACE_VIDEOOPTIONS	2
