/**********************************************************************

	--- Qt Architect generated file ---

	File: PhilipsControl.cc
	Last generated: Wed Nov 15 22:11:49 2000

 *********************************************************************/
#include <errno.h>

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "PhilipsControl.h"
#include "pwc-ioctl.h"

#define Inherited CPhilipsControlData

CPhilipsControl::CPhilipsControl(CVideoDevice *_video, QWidget* parent, const char* name)
	: Inherited( parent, name )
{
   int cam_fd, ag;

   pVideo = _video;
   pAGCTimer = new QTimer(this);
   connect(pAGCTimer, SIGNAL(timeout()), this, SLOT(AGCTick()));

   UserAgc = 32768;
   UserShutter = 32768;
   cam_fd = pVideo->GetDescriptor();
   if (ioctl(cam_fd, VIDIOCPWCGAGC, &ag) == 0) {
     if (ag < 0) { // auto
       AGCBox->setChecked(TRUE);
       AGCValue->setEnabled(FALSE);     
       AGCValue->setValue(-ag);
     }
     else { // manual mode
       UserAgc = ag;
       AGCBox->setChecked(FALSE);
       AGCValue->setEnabled(TRUE);     
       AGCValue->setValue(ag);
     }
     /* we don't have GSHUTTER */
   }
   else { // Assume we don't have AGC
     AGCBox->setChecked(FALSE);
     AGCBox->setEnabled(FALSE);
     AGCValue->setEnabled(FALSE);
   }
   ReadCompression();
}


CPhilipsControl::~CPhilipsControl()
{
}


// private

/**
  \brief This function reads the preferred compression setting from the device.
*/  
void CPhilipsControl::ReadCompression()
{
   int pref, cam_fd;

   UserCompression = -1;
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   if (!ioctl(cam_fd, VIDIOCPWCGCQUAL, &pref))
     UserCompression = pref;
   else
     fprintf(stderr, "Failed to get Compression Quality setting.\n");
   CompressionSelection->setButton(UserCompression);
}

// protected

void CPhilipsControl::SaveUserClicked()
{
   int cam_fd;
   
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   ioctl(cam_fd, VIDIOCPWCSUSER);
//   GetControl();
}
 
void CPhilipsControl::RestoreUserClicked()
{
   int cam_fd;
   
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   ioctl(cam_fd, VIDIOCPWCRUSER);
//   GetControl();
}

void CPhilipsControl::RestoreFactoryClicked()
{
   int cam_fd;
   
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   ioctl(cam_fd, VIDIOCPWCFACTORY);
//   GetControl();
}

/**
  User selected AGC (Automatic Gain Control) or not.
*/
void CPhilipsControl::ClickedAGCAuto(bool on)
{
   int cam_fd, ag;
   
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;

   AGCValue->setEnabled(!on);     
   if (on) { // Switch to auto mode
     UserAgc = AGCValue->value(); // store 
     ag = -1;
     pAGCTimer->start(1000);
   }
   else { // manual mode
     pAGCTimer->stop();
     ag = UserAgc;
     AGCValue->setValue(ag);
   }
   ioctl(cam_fd, VIDIOCPWCSAGC, &ag);
}

void CPhilipsControl::MovedAGC(int val)
{
   int cam_fd;

   if (pAGCTimer->isActive())
     return;
   
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   UserAgc = val;
   ioctl(cam_fd, VIDIOCPWCSAGC, &UserAgc);
}


void CPhilipsControl::ClickedShutterAuto(bool on)
{
   int sp, cam_fd;

   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;

   ShutterValue->setEnabled(!on);     
   if (on) { // Switch to auto mode
     UserShutter = ShutterValue->value(); // store 
     sp = -1;
   }
   else { // manual mode
     sp = UserShutter;
     ShutterValue->setValue(sp);
   }
   Trace(PHCONTROL_DLG, 2, "CPhilipsControl::ClickedShutterAuto(%s): %d\n", on ? "T" : "F", sp);
   ioctl(cam_fd, VIDIOCPWCSSHUTTER, &sp);
}

void CPhilipsControl::MovedShutter(int val)
{
   int cam_fd, ret;

   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   UserShutter = val;
   ret = ioctl(cam_fd, VIDIOCPWCSSHUTTER, &UserShutter);
   if (ret < 0)
     Trace(PHCONTROL_DLG, 1, "VIDIOCPWCSSHUTTER returns %d\n", errno);
}

/**
  \param pref A value between 0 and 3
*/  
void CPhilipsControl::ClickedCompression(int pref)
{
   int cam_fd;

   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   if (ioctl(cam_fd, VIDIOCPWCSCQUAL, &pref) < 0)
     fprintf(stderr, "Failed to set quality compression.\n");
}

   
/**
  When the AGC is set to automatic, its value is read every second and the
  slider updated.
*/  
void CPhilipsControl::AGCTick()
{
   int cam_fd, agvalue;
   cam_fd = pVideo->GetDescriptor();
   if (cam_fd < 0)
     return;
   if (ioctl(cam_fd, VIDIOCPWCGAGC, &agvalue) < 0)
     return;
   if (agvalue > 0)
     return; // Not in auto mode
   AGCValue->setValue(-agvalue); // update slider     
}


/**
  \brief overloaded hide()
  
  This function is overloaded so we can stop the AGC update timer when we lose focus.
*/
void CPhilipsControl::hide()
{
   pAGCTimer->stop();
   QDialog::hide();
}


/** 
  \brief overloaded show()
  
  This function is overloaded so we can start the AGC update timer when we gain focus.
*/  
void CPhilipsControl::show()
{
   QDialog::show();
   if (AGCBox->isChecked())
     pAGCTimer->start(1000);
}
