;;; @file c128.s
;;; Commodore 128 definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)
host = 128

;;; start address for the server program
serverstart = $1300
;;; start address for the utility programs
utilstart = $2000

#include "c64common.s"

bstart	= $2d	; start of basic program text
bend	= $1210 ; end of basic program text

bank	= $a9	; temporary variable that holds the memory bank
stack	= $105	; offset to the stack while in interrupt

peek	= $2a2
peekptr = $2aa
poke	= $2af
pokeptr = $2b9

linkprg = $4f4f
basrun	= $5aa6

	;; exit from an interrupt
#define irqexit jmp $ff33
	;; disable timer interrupts
#define deactirq sei
	;; re-enable timer interrupts
#define reactirq
	;; store the speed settings and enable fast speed
#define phfast lda $d030:pha:lda #$1:sta $d030
	;; restore original speed from fast speed
#define plfast pla:sta $d030
	;; store the speed settings and enable slow speed (no badlines)
#define phslow lda $d011:and #$7f:pha:lda $d015:pha:lda $d030:pha:\
	lda #$0:sta $d015:sta $d011:sta $d030:\
	.(:vblank bit $d011:bpl vblank:.)
	;; restore original speed from slow speed
#define plslow pla:sta $d030:pla:sta $d015:pla:sta $d011
