;;; @file ext.s
;;; Common definitions for cbmlink extensions
;;; @author Marko Mkel (msmakela@nic.funet.fi)

#include "rom.s"

fileno = 45			; a hopefully unused file number

	;; the jump table
install		= 0		; install the server
deinstall	= 3		; remove the server
prepare		= 6		; prepare for using the data link
send_switch	= 9		; switch from receive to send, and
send		= 12		; send a byte in .A; trash .A, maybe clear .Y
receive_switch	= 15		; switch from send to receive, and
receive		= 18		; receive a byte to .A; maybe set .Y=0
exit		= 21		; install the server and exit

;;; All extensions should perform "jsr prepare" as the first step.
;;; Extensions should perform "jmp exit" only when the last data
;;; action has been jsr receive_switch or jsr receive.  That is,
;;; the remote end must give the final command to terminate the extension.
* = utilstart
