#!/usr/bin/perl -w

# 2004-07-23
# Marko Crnic <paranoid@nymphomatic.org>
# http://www.nymphomatic.org/~paranoid/
#
# Fix date format in .hcf files (gzipped xml).
# .hcf is used by CdCat (http://cdcat.sf.net).

use Compress::Zlib ;

($a, $b) = @ARGV;

if(!$a || !$b)
{ 
	print "Usage: $0 infile.hcf outfile.hcf\n";
	exit 1;
}

$gz = gzopen("$a", "rb");
$out = gzopen("$b", "wb");

while($gz->gzreadline($lajna))
{
	if($lajna =~ /time="(.*)\.(.*) (\d+):(\d+) (\d{4})"/)
	{
		$hr = $3;
		$mn = $4;
		if($3 < 10) { $hr = "0$3"; }
		if($4 < 10) { $mn = "0$4"; }
		$lajna =~ s/time="(.*)\.(.*) (\d+):(\d+) (\d{4})"/time="$1 $2 $hr:$mn $5"/;
	}
	$out->gzwrite($lajna);
}

$out->gzclose();
$gz->gzclose();
