#
# 	Gestion des fichiers
# 	(c) 1995-7 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#

proc updateSoundOutDuree {} {
    global value soundOutInfo realArr
    if {[info exists value(duree_totale)]} {
		set soundOutInfo(duree) $value(duree_totale)
		}
    if {[info exists value(total_time)]} {
	set soundOutInfo(duree) $value(total_time) 
	}
    drawXGrid
}

proc getSoundInfo {nom} {
    global lan soundInInfo errno value path loading fs currentdir soundOutInfo prefs tcl_platform
    $path(winIn).f.$nom.play config -state disabled
    $path(winIn).f.$nom.edit config -state disabled
    set namer [file tail $value($nom)]
    set ret [file extension $value($nom)] 
    switch -- $ret {
	.lpc 	{set stuff "lpc analysis file"}
	.pv 	{set stuff "FFT analysis file"}
	.hetro 	{set stuff "hetro analysis file"}
	.cv 	{set stuff "convolution analysis file"}
	default {  
	    set fs [getSoundFileInfo $value($nom)]
	    if {[lindex $fs 2] != "aiff" && [lindex $fs 2] != "wave" && [lindex $fs 2] != "SDII"} {
			errFile2 "$lan(nom86)"
			chooseSoundPath $nom
			return
	    }

	    set soundInInfo($nom)  [lindex [split [lindex $fs 1] .] 0]  
	    lappend soundInInfo($nom)   [lindex $fs 3] 
	    lappend soundInInfo($nom)  [lindex $fs 0]
	    
	    setSoundOutDuree
	    
	    if {$tcl_platform(platform) != "windows"} {	    	
		$path(winIn).f.$nom.scale config -state normal \
		    -to [lindex $soundInInfo($nom) 2]
	    }
	    $path(winIn).f.$nom.play config -state normal -command "playSound \"$value($nom)\" $path(winIn).f.$nom.play"
	    $path(winIn).f.$nom.edit config -state normal -command "editSoundFile \"$value($nom)\""
	    set stuff  [lrange $fs 0 4] 
	}
    }

	set soundinf "[lindex $stuff 0] sec. - [lindex $stuff 1]Hz. - [lindex $stuff 2] - [lindex $stuff 3] \
		chn. - [lindex $stuff 4] bits"

    $path(winIn).f.$nom.b config -text $namer
    $path(winIn).f.$nom.label config -text $soundinf -fg black
}

proc setSoundOutDuree {} {
    global value soundOutInfo soundInInfo
    if {[info exists value(duree_totale)]} {
	bug going for the time slider...
	set soundOutInfo(duree) $value(duree_totale)
    } else {
	if {[info exists value(total_time)]} {
	    bug going for the time slider
	    set soundOutInfo(duree) $value(total_time)
	} else {
	    bug checking the soundins...
	    set soundOutInfo(duree) 0
	    foreach soundin [array names soundInInfo] {
		bug $soundin
		set soundDuree [lindex $soundInInfo($soundin) 2]
		if {$soundDuree > $soundOutInfo(duree)} {set soundOutInfo(duree) $soundDuree}
	    }
	}
    }	
    drawXGrid
}

proc openMidi {} {
    global selectedMIDIfile currentdir path midifile
    if {[info exists loading]} { return }
             set types {
			{{All Files} * }
 			{{MIDI Files}  {.mid} }
	       }
    set blue  [chooseOpen "Choose a MidiFile" $currentdir $types] 
    if {$blue == ""} {return}
    set boo [$path(panel).score.t search MidiFile 1.0 ]
    if {$boo != ""} {
		$path(panel).score.t delete "$boo linestart" "$boo lineend" 
    }
    $path(panel).score.t insert 1.0 "\n; MidiFile : $blue\n"
}

proc chooseSoundPath {nom} {
    global value lan currentdir loading
    if {[info exists loading]} { return }
    
             set types {
			{{All Files} * }
 			{{AIFF File}  {.aiff .AIFF}  AIFF }
			{{Pvoc File}  {.pv}  }
			{{LPC File}  {.lpc}  }
			{{Convolution File} {.cv} }
			{{AdSyn File}  {.het}}
       }

    set blue  [chooseOpen "Choose a sound file" $currentdir $types] 
    if {$blue == ""} {return}
    set value($nom) $blue
    getSoundInfo $nom
}

proc chooseMIDIPath {nom} {
    global value currentdir path prefs
    set blue  [chooseOpen "Choose a MIDI file" $currentdir {{"MIDI File" {.mid .midi} {Midi}}}] 
    if {$blue == ""} {return}
    set value($nom) $blue
    $path(winIn).f.$nom.b config -text $blue
    $path(winIn).f.$nom.edit config -state normal -command "\
	exec $prefs(help:MIDI) $value($nom) &"
}

proc rememberSound {nom} {
    global value _db
    if { $_db(sound,previous) != "toLoad"} {
	set value($nom) $_db(sound,previous) 
	getSoundInfo $nom
	set _db(time,reset) 1
	return 1
    } else {
	return 0 
    }
}

proc saveGraph {} {
    global module data value type nomModuleCourrant frbut3 realArr
    if {$nomModuleCourrant  == "untitled" | [file writable [file dirname $nomModuleCourrant]] == 0} {
		saveAsGraph
		return
	}
    set fichier [open $nomModuleCourrant w]
    puts $fichier "<snap>"
    puts $fichier $module(path)
    catch {unset value()}

    foreach graph [array names data] {
		    puts $fichier "$type($graph) $graph [list $data($graph)]"}
	
    foreach irate [array names value] {
		    puts $fichier "$type($irate) $irate \"$value($irate)\""}

    foreach item [array names type] {
    
	if {$type($item) == "kslider" | $type($item) == "cec_toggle" | $type($item) == "cec_option"} {
			    puts $fichier "$type($item) $item \"$realArr($item)\""}
    
    }
     

    puts $fichier "</snap>"
    close $fichier
    $frbut3.file entryconfigure 3 -state disabled
    updateModuleInfo
    bind .pre <ButtonRelease-1> "testChange"
}

proc saveAsGraph {} {
    global module lan fileselect frbut3 nomModuleCourrant currentdir
    set newf [chooseSave "Save snaphot as:" $currentdir $nomModuleCourrant]
    if {$newf == ""} {
		return
	} else {
		set nomModuleCourrant $newf
		saveGraph 
    }
}

proc openGraph { nomDuFichier} {
    global data fileselect type path value midifile selectedMIDIfile realArr
    global loading initgraph nomModuleCourrant graphOrig slideOrig
    set loading 1
    set fichier [open $nomDuFichier r]
    set stuff [read $fichier]
    close $fichier    
    set nomDuModule [lindex [split $stuff \n] 1]
    if {![file exists $nomDuModule]} {
		puts "error: can't find $nomDuModule."
    } else {
		parseModule $nomDuModule
		set nomModuleCourrant $nomDuFichier
		updateModuleInfo
		foreach ligne [lrange [split $stuff \n] 2 end] {
		    set t [string trim [lindex $ligne 0]]
		    set n [lindex $ligne 1]
		    set d [lindex $ligne 2]
		    switch  -- $t {
				cs_graph    {set t cec_graph}
				cs_sound    {set t cec_filein}
	    	}

	    	switch  -- $t {
				cec_graph {
				    set data($n) $d
				    updatePoints $n
				    updateLine $n
				}
				cec_filein {
				    if {$d != "toLoad"} {
						$path(winIn).f.$n.b config -text [file tail $d] 
						set value($n) $d
						getSoundInfo $n
				    } else {
						set soundInInfo($nom) ""
						set value($nom) "toLoad" 
				    }
				}
				kslider  {
				    set realArr($n) $d
				}
				cec_option  {
				    set realArr($n) $d
				}
				cec_toggle  {
				    set realArr($n) $d
				}
				default {
				    set value($n) $d
				}
	    	}
		}	
    }
    update
    set graphOrig [array get data]
    set slideOrig  [array get value]
    if [info exists initGraph] {
	set actif [lindex [array names data] 0]
	selectGraph $actif
	$path(param).select$actif select
    }
    unset loading    
    showEditWindow 0
    setBitbind on
}

proc saveActifGraph {} {
    global  data  actif fileselect homedir lan currentdir
    set newf [chooseSave "Saving graph" $currentdir $actif.grf]
    if {$newf == "" } {
		return
	} else {
		set fichier [open $newf.grf w]
		puts $fichier $data($actif)     
		close $fichier
    }
}

proc openActifGraph {} {
	global data actif lan homedir currentdir
	            set types {
			{{All Files} * }
 			{{Cecilia Graph} {.grf} }
		      }
     set newf [chooseOpen "Choose a Cecilia graph file" $currentdir $types]
    if {$newf != "" } {
    	set data($actif) [read [open $newf r]]
    	redrawLine $actif
    }
}

proc openScore {} {
    global path  lan  currentdir
    set types {
	{{All Files} * }
	{{Csound Sco} {.sco} }
    }
    if {[set newf [chooseOpen "Choose a Csound score" $currentdir $types]] != "" } {
    	set score [read [open $newf r]] 
    	$path(panel).score.t delete 0.0 end
    	$path(panel).score.t insert 0.0 $score
    }
}

proc saveScore {} {
	global currentdir path fileselect
    if {[set newp [chooseSave "Exporting Csound score" $currentdir "untitled score"]] != "" } {
		set fichier [open $newp w]
		puts $fichier [$path(panel).score.t get 0.0 end]    
		close $fichier
		set fileselect(done) 1
    }

}

proc doCloseCheck {} {
    global module errno lan   tcl_platform
    if {[wm title .edit] ==   "Cecilia: Editor: $module(nom)***"} {		
	    errFile6  "Module $lan(nom104)" 
	    set hhh $errno
	    switch $hhh {
	
	 "yes" {saveModule;return 2}
	 "no"  { wm title .edit  "Cecilia: Editor: $module(nom)";return 1 }
	 "cancel" {return 0}
	}
    }
}

proc closureCheck {} {
    global path module nomModuleCourrant errno lan frbut3 tcl_platform
   if {[$path(winModule)  cget  -text] == "$module(nom): [lindex [split [file tail $nomModuleCourrant ] . ] 0]***"} {
	    errFile6  "Snapshot $lan(nom104)" 
	    set hhh $errno
	switch $hhh {
	"yes" {$frbut3.file invoke 3;return 2}
	"no" {return 1}
	"cancel" {return 0}
	}
  }
}


proc openModule {} {
    global currentdir lan tcl_platform
    if {$tcl_platform(platform) == "unix"} {
	set types {
	    {{All Files} * }
	    {{Cecilia Module}  {.cec }  }
	    {{Cecilia Snap}  {.snap}  }
	    {{Csound Orc} {.orc} }
	}
    } {
	set types {
	    {{Cecilia Files} {} {{TEXT}}}
	}
    }
    
    if {[doCloseCheck] == 0} {return}
    if {[closureCheck] == 0} {return}
    if { [set thing [chooseOpen $lan(nom76a) $currentdir $types]] == ""} {return}

    regsub -all {\"} [read [open $thing r]] {\\\"} tex
    regsub -all "\};" $tex "\} ;" tex
    if {[lindex $tex 0] == "\<info\>" } {
	parseModule $thing
	showEditWindow 1
	setBitbind on
    } elseif {[lindex $tex 0] == "\<snap\>" } {
	showEditWindow 0
	openGraph $thing
	setBitbind on
    } elseif {[string first "endin" $tex] != "-1"} {
	importCsound $thing
	setBitbind on
    } else {
	set mess "I can't deal with \"$thing\". \nFile must be a Cecilia module,\na Cecilia snapshot, or a Csound orchestra!"
	if {$tcl_platform(platform) == "unix"} {
	    errFile2 $mess
	} else {
	    tk_messageBox -type ok -icon warning   -message $mess 	
	}
	openModule
    }
    
}

proc saveAsModule {} {
    global fileselect module currentdir path
    if {[set newf [chooseSave "Save Module As" $currentdir $module(nom)]] != "" } {
		set newp $newf
		set fichier [open $newp w]
		puts $fichier [dumpEditWindow]    
		close $fichier
		set fileselect(done) 1
        wm title .edit "Cecilia: Editor: $module(nom)"
		set module(path) $newp
		parseModule $newp
		setBitbind on
    }
}

proc saveModule {} {
    global module bitBind path
    if {[file extension $module(nom) ] == ".CStemp"} { 
	    if {[info exists value]} {
		errFile "You have added interface objects to this Csound file.\n \
		    Press \"Cancel\" to save as a Module, or press \"OK\" to save \n \
		    as Csound documents (Interface objects will not be saved!)"
		if {$errno == 0} {return}
	    }
	    saveasCsound
	    setBitbind on
	} elseif {$module(nom) == "untitled.cec" | $module(nom) == "untitled.cec***" | [file writable $module(path)] == 0} {
		saveAsModule
	} else {
		set fichier [open $module(path) w]
    	puts $fichier [dumpEditWindow]    
    	close $fichier
    	wm title .edit "Cecilia: Editor: $module(nom)"
    	setBitbind on
    }
}

proc exportCsound {} {
	global module soundOutInfo path currentdir
	if {[set namer [chooseSave "Save as Csound pair" $currentdir untitled]] != "" } {
	    if {[info exists value]} {
		errFile "You have added interface objects to this Csound file.\n \
		    Press \"Cancel\" to save as a Module, or press \"OK\" to save \n \
		    as Csound documents (Interface objects will not be saved!)"
		if {$errno == 0} {return}
	    }
	    set module(path) $namer.tmp
	    saveasCsound
	    importCsound $namer.orc
	}	
}



proc saveasCsound {} {
	global module soundOutInfo path bitBind tags value errno prefs

set prefs(nchnls) 1

	set orcname "[file rootname $module(path)].orc"
 	set sconame "[file rootname $module(path)].sco"
	set fichier [open $orcname w]
	puts $fichier "sr = $soundOutInfo(userSR)"
	puts $fichier "kr = [expr $soundOutInfo(userSR)/ $soundOutInfo(userKSM)]"
	puts $fichier "ksmps = $soundOutInfo(userKSM)"
	if {$soundOutInfo(userCHN) == "stereo"} { puts $fichier "nchnls = 2\n"} else {puts $fichier "nchnls = 1\n"}
	if {$soundOutInfo(userCHN) == "stereo"} {
		puts -nonewline $fichier "[$path(panel).stereo.t get 1.0 end]"
    } else {
		puts -nonewline $fichier "[$path(panel).mono.t get 1.0 end]"
	}
	close $fichier
	set fichier [open $sconame w]
	puts -nonewline $fichier "[$path(panel).score.t get 1.0 end]"
	close $fichier
    wm title .edit "Cecilia: Editor: $module(nom)"
    setBitbind on
}

proc importCsound {cible} {	
    global currentdir soundOutInfo path env prefs nchnls tcl_platform
	
    set orc ""
    set score ""
    set cib [open $cible r]
    set orc [read $cib]
    set dir [file dirname $cible ]  
    set namer2 [file tail [file rootname $cible]]
	set namer [file join $prefs(TMPDIR) $namer2.CStemp]
   set grab(sr)     $soundOutInfo(userSR)
    set grab(kr)     $soundOutInfo(userKR)
    set grab(ksmps)  $soundOutInfo(userKSM)
    set grab(nchnls) $soundOutInfo(userCHN)
    
    set sco "[file rootname $cible].sco"
    if [file exists $sco] {
        set score [read [open $sco r]] 
    } else {
	errFile2 "Cant' find \n $sco. \nOpening orchestra alone!"	
    }
    close $cib

     regsub -all \" $orc \\\" orcOK

    set headers {sr kr ksmps nchnls}
    set out ""
    if [array exists grab] {unset grab}
    foreach l [split $orcOK \n] {
		set ok 0
		foreach h $headers {
			if [regexp -- ^\[\ |\t\]*$h $l] {
				if [regexp -- .*$h\[\ |\t\]*=\[\ |\t\]*\[0-9.\]*\[\ |\t\]*($)|(\;) $l] {
					regsub = $l \  l2
					set grab($h) [lindex $l2 1]
					set ok 1
					set i [lsearch $headers $h]
					set headers [lreplace $headers $i $i]
					break
				} 	
			}
		}
		if $ok  {append out "\; $l (commented by Cecilia)\n" } {append out $l\n }
	}

	if [array exists grab] {}
	if [llength $headers] {
		puts "not found: $headers\nSubstituting to defaults"
		foreach gg $headers {
			puts $gg
			puts $prefs($gg)
			set grab($gg) $prefs($gg)
		}
	}
	
	set boo [open  $namer w]
    foreach dx {d1 d2 d4} {set $dx \n}
	
    if {$tcl_platform(platform) != "macintosh"} {
	  set info "grabbed on [exec date] from [file rootname $cible].*"
    } {
	  set info "converted from orc&sco files"
    }
    set d$grab(nchnls) $out
    puts -nonewline $boo [concat "<doctype>\ncsound\n</doctype>\n<info>\n</info>\n<interface>\n</interface>\n<mono>$d1</mono>\n<stereo>\n$d2\n</stereo>\n<quad>$d4</quad>\n<score>\n$score\n</score>"]

    close $boo
    parseModule  $namer
    hideAll
    if {$grab(nchnls) == 2} {
		set soundOutInfo(userCHN) stereo	 
		$path(panel).stereo.t mark set insert end
		set from [$path(panel).stereo.t search -backwards  -regexp (\[a-z\]+) insert]
		$path(panel).stereo.t delete "$from + 2 lines" end
		showAll
		$path(edit).menu.section invoke 0
		$path(edit).menu.section invoke 1
		$path(edit).menu.section invoke 2
		$path(edit).menu.section invoke 4
		$path(edit).menu.section invoke 6
		$path(edit).menu.section invoke 7
		$path(edit).menu.section invoke 8
		
#		set toggleState(score) 1
    } else {
		set soundOutInfo(userCHN) mono
		$path(panel).mono.t mark set insert end
		set from [$path(panel).mono.t search -backwards  -regexp (\[a-z\]+) insert]
		$path(panel).mono.t delete "$from + 2 lines" end
		showAll
		$path(edit).menu.section invoke 0
		$path(edit).menu.section invoke 1
		$path(edit).menu.section invoke 3
		$path(edit).menu.section invoke 4
		$path(edit).menu.section invoke 6
		$path(edit).menu.section invoke 7
		$path(edit).menu.section invoke 8
#		set toggleState(score) 1
     }
	$path(panel).score.t mark set insert end
     set soundOutInfo(userSR)  $grab(sr)
     set soundOutInfo(userKSM) $grab(ksmps)
     set soundOutInfo(userKR) $grab(kr)
     set soundOutInfo(userCHN) $nchnls($grab(nchnls))
    catch {file  delete $namer}
    update
    showEditWindow 1
}




proc getTheHead {arc} {
    set blue true 
    global test
    regsub -all \" $arc \\\" arc
    set begin [lsearch $arc "nchnls"]
    if {$begin == "-1"} {set begin [lsearch -regexp $arc "ksmps"] ; set blue false}
    set orc [lrange $arc 0 [expr $begin + 50]]
    regsub -all "=" $orc " = " orc
    regsub -all ";" $orc " ; " orc 
    
    set sr [lindex $orc [expr [lsearch $orc "sr"] + 2]]
    set ksmps [lindex $orc [expr [lsearch $orc "ksmps"] + 2]]
    if {$blue == "false"} {set nchnls 1} else {
    set nchnls [lindex $orc [expr [lsearch $orc nchnls] + 2]  ] }
    return "$sr $ksmps $nchnls $begin"
}


proc chooseOpen {args} {
global tcl_platform

   set message [lindex $args 0]
    set dir [lindex $args 1]
    set types [lindex $args 2]
    switch $tcl_platform(platform) {
	unix {
	    return [fileselector $message $dir $types 0]
	}
	default {
	    return [tk_getOpenFile -title ${message} -initialdir ${dir} -filetypes ${types}]
	}
    }
}

proc chooseSave {args} {
global tcl_platform

   set message [lindex $args 0]
    set dir [lindex $args 1]
    set types [lindex $args 2]
    switch $tcl_platform(platform) {
	unix {
	    return [fileselector $message $dir $types 1]
	}
	default {
	    return [tk_getSaveFile -title ${message} -initialdir ${dir}]
	}
    }
}
