;;; modules.scm - A simple module system for Chicken
;
; Copyright (c) 2000-2002, Felix L. Winkelmann
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
; conditions are met:
;
;   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
;     disclaimer. 
;   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
;     disclaimer in the documentation and/or other materials provided with the distribution. 
;   Neither the name of the author nor the names of its contributors may be used to endorse or promote
;     products derived from this software without specific prior written permission. 
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
; CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
; OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.
;
; Send bugs, suggestions and ideas to: 
;
; felix@call-with-current-continuation.org
;
; Felix L. Winkelmann
; Steinweg 1A
; 37130 Gleichen, OT Weissenborn
; Germany


(declare
  (unit modules)
  (usual-integrations)
  (interrupts-disabled)
  (no-bound-checks) )


(include "parameters")


(define ##sys#module-list
  '((scheme
     set! if define begin let let* letrec and or cond case else ... define-syntax syntax-rules _ quote
     not boolean? apply call-with-current-continuation eq? eqv? equal? pair? cons car cdr caar cadr
     cdar cddr caaar caadr cadar caddr cdaar cdadr cddar cdddr caaaar caaadr caadar caaddr cadaar
     cadadr caddar cadddr cdaaar cdaadr cdadar cdaddr cddaar cddadr cdddar cddddr set-car! set-cdr!
     null? list list? length zero? * - + / > < >= <= = current-output-port current-input-port
     write-char newline write display append symbol->string char? char->integer => do
     integer->char eof-object? vector-length string-length string-ref string-set! vector-ref 
     vector-set! char=? char<? char>? char>=? char<=? gcd lcm reverse symbol? string->symbol
     number? complex? real? integer? rational? odd? even? positive? negative? exact? inexact?
     max min quotient remainder modulo floor ceiling truncate round exact->inexact inexact->exact
     exp log sin expt sqrt cos tan asin acos atan number->string string->number char-ci=?
     char-ci<? char-ci>? char-ci>=? char-ci<=? char-alphabetic? char-whitespace? char-numeric?
     char-lower-case? char-upper-case? char-upcase char-downcase string? string=? string>? string<?
     string>=? string<=? string-ci=? string-ci<? string-ci>? string-ci<=? string-ci>=?
     string-append string->list list->string vector? vector->list list->vector string read list-ref list-tail
     read-char substring vector-fill! make-string make-vector open-input-file input-port? output-port?
     open-output-file call-with-input-file call-with-output-file close-input-port close-output-port
     values call-with-values vector procedure? memq memv assq assv member assoc map for-each
     transcript-on transcript-off eval lambda abs quasiquote unquote unquote-splicing peek-char
     delay force page backspace space return linefeed tab with-input-from-file with-output-to-file
     scheme-report-environment interaction-environment null-environment load)

    (syntax-case
     syntax-case with-syntax syntax generate-temporaries implicit-identifier free-identifier=? bound-identifier=?
     syntax-error syntax-object->datum identifier?)

    (chicken-library
     library
     define-macro define-constant define-inline define-integrable declare include let-values
     let-optionals let-optionals* :optional when unless case-lambda and-let* fluid-let
     define-values define-module let*-values set!-values letrec-values parameterize
     receive define-id-macro let-id-macro let-macro define-record record-case assert
     cond-expand critical-section eval-when nth-value time void end-of-file print-to-string
     compile port? generic error keyword? get-keyword keyword->string string->keyword
     always-bound foreign-declare unit uses inline inline-limit interrupts-enabled interrupts-disabled
     block-global no-bound-checks no-procedure-checks no-argc-checks
     fixnum-arithmetic fixnum flonum no-fancy-ports no-winding-callcc notinline number-type
     standard-bindings extended-bindings usual-integrations unsafe safe bound-to-procedure
     command-line-arguments eval-handler error-handler reset-handler implicit-exit-handler exit-handler
     gensym print add1 sub1 bitwise-and bitwise-ior bitwise-xor bitwise-not arithmetic-shift fixnum?
     fx+ fx- fx* fx/ fxmod fxneg fx> fx< fx= fx>= fx<= fxmin fxmax signum current-error-port flush-output
     port-name port-position delete-file file-exists? pathname-directory-separator pathname-extension-separator
     rename-file get-output-string open-output-string open-input-string argv current-milliseconds
     current-seconds enable-interrupts disable-interrupts errno exit features register-feature! gc getenv
     machine-type make-parameter software-type reset set-gc-report! string->uninterned-symbol
     system vector-copy! unregister-feature! define-record-printer get-line-number
     load-noisily read-eval-print-loop macro? macroexpand undefine-macro! define-reader-ctor
     case-sensitive set-finalizer! load-srfi-7-program
     exn user-interrupt make-property-condition condition? signal abort make-composite-condition
     with-exception-handler current-exception-handler handle-exceptions message arguments
     condition-predicate condition-property-accessor reason
     macroexpand-1)

    (chicken-ffi
     define-foreign-parameter foreign-lambda foreign-lambda* foreign-callback-lambda
     foreign-callback-lambda* define-external foreign-callback-wrapper external-pointer
     define-foreign-type define-foreign-variable scheme-object bool int integer long short char
     unsigned-long unsigned-short unsigned-char unsigned-int unsigned-integer float double pointer
     c-pointer c-string struct union function define-entry-point)

    (srfi-1
     list-tabulate cons* list-copy iota circular-list proper-list? dotted-list? circular-list? not-pair? list= null-list?
     length+ zip first second third fourth fifth sixth seventh eighth ninth tenth car+cdr take drop take! take-right
     drop-right drop-right! split-at split-at! last last-pair unzip1 unzip2 unzip3 unzip4 unzip5 append!
     append-reverse append-reverse! concatenate concatenate! count  unfold-right unfold  fold fold-right 
     pair-fold-right pair-fold reduce reduce-right append-map append-map! pair-for-each map! filter-map map-in-order
     filter filter! partition partition! remove remove! delete delete! delete-duplicates delete-duplicates!
     alist-cons alist-copy alist-delete alist-delete! find find-tail take-while drop-while take-while! span span!
     break break! any every list-index reverse! lset<= lset= lset-adjoin lset-union lset-union! lset-intersection
     lset-intersection! lset-difference lset-difference! lset-xor lset-xor! lset-diff+intersection
     lset-diff+intersection!)

    (string-lib
     infix strict-indix suffix prefix
     string-map string-map! string-fold string-unfold string-fold-right string-unfold-right string-tabulate string-for-each 
     string-for-each-index string-every string-any string-hash string-hash-ci string-compare string-compare-ci
     string=    string<    string>    string<=    string>=    string<> string-ci= string-ci< string-ci> string-ci<= 
     string-ci>= string-ci<> string-downcase  string-upcase  string-titlecase  string-downcase! string-upcase! string-titlecase! 
     string-take string-take-right string-drop string-drop-right string-pad string-pad-right string-trim string-trim-right
     string-trim-both string-filter string-delete string-index string-index-right string-skip  string-skip-right string-count
     string-prefix-length string-prefix-length-ci string-suffix-length string-suffix-length-ci string-prefix? string-prefix-ci?
     string-suffix? string-suffix-ci? string-contains string-contains-ci string-copy! substring/shared string-reverse
     string-reverse! reverse-list->string string-concatenate string-concatenate/shared string-concatenate-reverse
     string-append/shared xsubstring string-xcopy! string-null? string-join string-tokenize string-replace
     make-kmp-restart-vector string-kmp-partial-search kmp-step)

    (string-lib-internals 
     string-parse-start+end string-parse-final-start+end let-string-start+end check-substring-spec substring-spec-ok?)

    (srfi-14
     char-set? char-set= char-set<= char-set-hash  char-set-cursor char-set-ref char-set-cursor-next end-of-char-set?
     char-set-fold char-set-unfold char-set-unfold! char-set-for-each char-set-map char-set-copy char-set  list->char-set
     string->char-set char-set! list->char-set! string->char-set! filterchar-set  ucs-range->char-set  ->char-set
     filterchar-set! ucs-range->char-set! char-set->list char-set->string char-set-size char-set-count char-set-contains?
     char-set-every char-set-any char-set-adjoin  char-set-delete char-set-adjoin! char-set-delete! char-set-complement
     char-set-union  char-set-intersection  char-set-difference char-set-complement! char-set-union! char-set-intersection! 
     char-set-difference! char-set-difference char-set-xor  char-set-diff+intersection char-set-difference! char-set-xor!
     <char-set>
     char-set-diff+intersection! char-set:lower-case		char-set:upper-case	char-set:title-case
     char-set:letter		char-set:digit		char-set:letter+digit
     char-set:graphic		char-set:printing	char-set:whitespace
     char-set:iso-control	char-set:punctuation	char-set:symbol
     char-set:hex-digit		char-set:blank		char-set:ascii
     char-set:empty		char-set:full)

    (format format)

    (debugger (break . ##sys#break))

    (chicken-lolevel
     serialize deserialize move-memory! null-pointer null-pointer? pointer->address address->pointer 
     extend-procedure extended-proccedure? procedure-data set-procedure-data! byte-vector
     byte-vector-fill! make-byte-vector byte-vector-ref byte-vector-set! byte-vector? byte-vector->list
     list->byte-vector byte-vector-length make-static-byte-vector static-byte-vector->pointer
     block-ref block-set! number-of-slots evict copy release evicted?)

    (srfi-18
     not-owned abandoned not-abandoned
     current-time time->seconds seconds->time time? raise
     join-timeout-exception? abandoned-mutex-exception? terminated-thread-exception? uncaught-exception?
     uncaught-exception-reason make-thread thread? current-thread
     thread-specific thread-specific-set! thread-quantum thread-quantum-set! thread-name
     thread-start! thread-join! thread-terminate! thread-yield! thread-suspend! thread-resume!
     thread-sleep! mutex? make-mutex mutex-name mutex-owner mutex-specific mutex-specific-set!
     mutex-state mutex-lock! mutex-unlock! make-condition-variable condition-variable?
     condition-variable-specific condition-variable-specific-set! condition-variable-signal!
     condition-variable-broadcast!)

    (srfi-4
     u8vector s8vector u16vector s16vector u32vector s32vector f32vector f64vector
     u8vector? s8vector? u16vector? s16vector? u32vector? s32vector? f32vector? f64vector?
     u8vector-ref s8vector-ref u16vector-ref s16vector-ref u32vector-ref s32vector-ref f32vector-ref f64vector-ref
     u8vector-set! s8vector-set! u16vector-set! s16vector-set! u32vector-set! s32vector-set! f32vector-set! f64vector-set!
     u8vector->list s8vector->list u16vector->list s16vector->list u32vector->list s32vector->list f32vector->list f64vector->list
     u8vector-length s8vector-length u16vector-length s16vector-length u32vector-length s32vector-length f32vector-length 
     f64vector-length
     u8vector->byte-vector s8vector->byte-vector u16vector->byte-vector s16vector->byte-vector u32vector->byte-vector 
     s32vector->byte-vector f32vector->byte-vector f64vector->byte-vector
     list->u8vector list->s8vector list->u16vector list->s16vector list->u32vector list->s32vector list->f32vector list->f64vector
     byte-vector->u8vector byte-vector->s8vector byte-vector->u16vector byte-vector->s16vector byte-vector->u32vector 
     byte-vector->s32vector byte-vector->f32vector byte-vector->f64vector
     make-u8vector make-s8vector make-u16vector make-s16vector make-u32vector make-s32vector make-f32vector make-f64vector
     <u8vector> <s8vector> <u16vector> <s16vector> <u32vector> <s32vector> <f32vector> <f64vector>)

    (match
     match match-lambda $ ? match-define match-letrec match-let match-let* match-lambda* ..1 ..2 ..3 ..4
     ___ __1 __2 __3 __4 get! define-structure define-const-structure ! @ match-error-control)

    (chicken-unistd
     open/rdonly open/wronly open/rdwr open/read open/write _o_wronly open/creat _o_creat open/append open/excl 
     open/noctty open/nonblock
     open/trunc open/sync perm/irusr perm/iwusr perm/ixusr perm/irgrp perm/iwgrp perm/ixgrp perm/iroth perm/iwoth
     perm/ixoth perm/irwxu perm/irwxg perm/irwxo perm/isvtx perm/isuid perm/isgid
     file-open file-close file-read file-write file-select seek/set seek/end seek/cur file-size
     file-modification-time file-owner file-position set-file-position!
     create-directory change-directory delete-directory directory directory? current-directory
     open-input-pipe open-output-pipe close-input-pipe close-output-pipe
     call-with-input-pipe call-with-output-pipe with-input-from-pipe with-output-to-pipe
     create-pipe get-host-name
     absolute-pathname? make-pathname make-absolute-pathname decompose-pathname
     pathname-directory pathname-file pathname-extension pathname-strip-directory pathname-strip-extension
     pathname-replace-directory pathname-replace-file pathname-replace-extension
     create-temporary-file glob pattern->regexp
     signal/term signal/kill signal/int signal/hup signal/fpe signal/ill signal/segv signal/abrt signal/trap
     signal/quit signal/alrm signal/vtalrm signal/prof signal/io signal/urg signal/chld signal/cont signal/stop
     signal/tstp signal/pipe signal/xcpu signal/xfsz signal/usr1 signal/usr2 signal/winch
     set-signal-handler! set-signal-mask!
     process-form process-execute process-wait current-process-id parent-process-id process-run
     process-signal
     system-information user-information
     errno/perm errno/noent errno/srch errno/intr errno/io errno/noexec errno/badf errno/child errno/nomem errno/acces
     errno/fault errno/busy errno/notdir errno/isdir errno/inval errno/mfile errno/nospc errno/spipe errno/pipe
     errno/again errno/rofs
     change-file-mode change-file-owner current-user-id current-group-id current-effective-group-id
     current-effective-user-id set-user-id!
     file-read-access? file-write-access? file-execute-access? file-permissions
     create-symbolic-link read-symbol-link
     fileno/stdin fileno/stdout fileno/stderr
     open-input-file* open-output-file* port->fileno duplicate-fileno
     file-truncate file-lock file-test-lock file-unlock
     create-fifo fifo?
     setenv unsetenv current-environment
     prot/read prot/write prot/exec prot/none map/fixed map/shared map/private map/anonymous map/file
     map-file-to-memory unmap-file-from-memory
     seconds->local-time seconds->utc-time seconds->string time->string
     _exit set-alarm! set-buffering-mode! terminal-port? terminal-name
     <lock> <mmap>)

    (chicken-regex
     string-match string-match-positions string-search string-search-positions string-split-fields
     string-substitute pattern->regexp grep)

    (tinyclos
     make-class make-generic make-method add-method make initialize slot-ref slot-set! class-of
     class-direct-supers class-direct-slots class-cpl class-slots generic-methods method-specializers
     method-procedure allocate-instance compute-cpl compute-slots compute-getter-and-setter
     compute-apply-generic compute-methods compute-method-more-specific? compute-apply-methods
     define-class define-generic define-method initialize-slots print-object call-next-method
     <object> <class> <procedure-class> <generic> <method> <boolean> <symbol> <char> <pair> <vector>
     <number> <string> <procedure> <port> <byte-vector> <structure> <entity-class> <primitive-class>
     <primitive> <top> subclass? <condition> <time>
     direct-supers direct-slots cpl getters-n-setters slots nfields field-initializers methods name
     specializers procedure instance? <end-of-file> <input-port> <output-port> describe-object)

    (chicken-extras
     butlast chop flatten intersperse tail?
     call-with-input-string call-with-output-string with-input-from-string with-output-to-string
     fprintf sprintf printf
     get put! hash-table-set! hash-table-ref make-hash-table hash-table-for-each hash-table-count
     list->queue queue->list make-queue queue? queue-add! queue-remove! queue-first queue-last queue-empty?
     merge merge! sort sort! sorted?
     random randomize make-input-port make-output-port pretty-print read-line write-line
     pretty-print-width read-file
     read-lines read-string with-error-output-to-port with-input-from-port with-output-to-port
     (string-any . ##extras#string-any)
     (string-every . ##extras#string-every)
     string-capitalize string-capitalize! 
     (string-upcase . ##extras#string-upcase)
     (string-upcase! . ##extras#string-upcase!)
     (string-downcase . ##extras#string-downcase)
     (string-downcase! . ##extras#string-downcase!)
     (string-concatenate . ##extras#string-concatenate)
     (string-filter . ##extras#string-filter)
     (string-index . ##extras#string-index)
     (string-trim . ##extras#string-trim)
     string-left-trim string-right-trim 
     (string-map . ##extras#string-map)
     (string-map! . ##extras#string-map!)
     (string-reverse . ##extras#string-reverse)
     (string-reverse! . ##extras#string-reverse!)
     string-split
     substring-index string-translate substring-index-ci
     constantly flip compose complement) ) )

(set! ##sys#module-list
  (cons (cons 'char-set-lib (cdr (assq 'srfi-14 ##sys#module-list)))
	(cons (cons 'srfi-13 
		    (append (cdr (assq 'string-lib-internals ##sys#module-list))
			    (cdr (assq 'string-lib ##sys#module-list)) ) )
	      ##sys#module-list) ) )

(define ##sys#module-unit-map
  '(format srfi-13 srfi-14 srfi-18 match srfi-4 srfi-1 tinyclos debugger
    (chicken-extras . extras) (chicken-lolevel . lolevel) 
    (chicken-unistd . unistd) (chicken-regex . regex) ) )

(define ##sys#processing-module-definition #f)
(define ##sys#unresolved-imports '())
(define ##sys#repository-loaded #f)

(define ##sys#expand-module-definition
  (let ([string-append string-append] 
	[string string] 
	[vector->list vector->list]
	[list->vector list->vector]
	[make-vector make-vector] )
    (lambda (name clauses err0 . b-n-x)
      (let* ([mdef (assq name ##sys#module-list)]
	     [namestr (##sys#symbol->string name)]
	     [imports '()]
	     [exports '()] 
	     [itab #f]
	     [files '()]
	     [used '()]
	     [unit #f]
	     [unq #f]
	     [forms-used #f]
	     [builder (:optional b-n-x ##sys#default-module-form-builder)]
	     [expander 
	      (or (and (pair? b-n-x) (:optional (cdr b-n-x) #f))
		  ##sys#compiler-toplevel-macroexpand-hook) ]
	     [prefix (string-append (string (integer->char (##sys#size namestr))) namestr)] )

	(define (err msg . args)
	  (apply ##sys#error (string-append "in module definition `" namestr "': " msg) args) )

	(define (update! str sym m)
	  (when (lookup str) (err "symbol multiply imported" sym m))
	  (set! imports (cons (cons str sym) imports)) )

	(define (lookup str) (assoc str imports))

	(define (resolve name)
	  (cond [(lookup name) => cdr]
		[else 
		 (##sys#string->symbol
		  (if unq name (string-append prefix name)) ) ] ) )

	(define (findunit m)
	  (let loop ([mus ##sys#module-unit-map])
	    (and (pair? mus)
		 (let ([mu (##sys#slot mus 0)])
		   (if (eq? m (if (pair? mu) (##sys#slot mu 0) mu))
		       (if (pair? mu) (##sys#slot mu 1) mu)
		       (loop (##sys#slot mus 1)) ) ) ) ) )

	(define (hashs str)
	  (##core#inline "C_fixnum_modulo" (##core#inline "C_hash_string" str) namespace-size) )

	(define (qualify-forms forms)
	  (let walk ([x forms])
	    (cond [(symbol? x)
		   (let* ([str (##sys#slot x 1)]
			  [i (hashs str)] )
		     (when (fx<= (##sys#byte str 0) namespace-max-id-len)
		       (err "qualified symbol syntax is not allowed" str) )
		     (let loop ([bucket (##sys#slot itab i)])
		       (if (null? bucket)
			   (##sys#string->symbol (string-append prefix str))
			   (let ([e (##sys#slot bucket 0)])
			     (if (string=? str (##sys#slot e 0))
				 (##sys#slot e 1)
				 (loop (##sys#slot bucket 1)) ) ) ) ) ) ]
		  [(pair? x)
		   (cons (walk (##sys#slot x 0)) (walk (##sys#slot x 1))) ]
		  [(vector? x)
		   (list->vector (walk (vector->list x))) ]
		  [else x] ) ) )

	(define (import-all m mdef mexports)
	  (unless mdef (err "can not import - module is not defined" m))
	  (for-each
	   (lambda (exp)
	     (if (pair? exp)
		 (update! (##sys#slot (##sys#slot exp 0) 1) (##sys#slot exp 1) m)
		 (update! (##sys#slot exp 1) exp m) ) )
	   mexports) )

	(unless ##sys#repository-loaded (##sys#load-interface-repository))
	(when ##sys#processing-module-definition
	  (err "nested module definitions are not allowed") )
	(unless mdef
	  (set! mdef (cons name '()))
	  (set! ##sys#module-list (cons mdef ##sys#module-list)) )
	(set-cdr! mdef '())
	(for-each
	 (lambda (clause)
	   (##sys#check-syntax 'define-module clause '(symbol . #(_ 0)) clause)
	   (case (##sys#slot clause 0)
	     [(unqualified) (set! unq #t)]
	     [(export)
	      (##sys#check-syntax 'export clause '(_ . #(symbol 0)) clause)
	      (set! exports
		(append (map (lambda (exp) (cons exp (resolve (##sys#slot exp 1)))) (##sys#slot clause 1))
			exports) ) ]
	     [(import)
	      (##sys#check-syntax 'import clause '(_ . #(_ 0)) clause)
	      (for-each
	       (lambda (imp)
		 (when (symbol? imp) (set! imp (list imp)))
		 (##sys#check-syntax 'import imp '(symbol . #(_ 0)))
		 (let* ([m (##sys#slot imp 0)]
			[mstr (##sys#slot m 1)]
			[syms (##sys#slot imp 1)]
			[unr '()]
			[mdef (assq m ##sys#module-list)] 
			[mprefix (string-append (string (integer->char (##sys#size mstr))) mstr)] )
		   (unless (memq m used) 
		     (let ([u (findunit m)])
		       (when u (set! used (append used (list u)))) ) )
		   (let ([mexports (and mdef (##sys#slot mdef 1))])
		     (if (null? syms)
			 (import-all m mdef mexports)
			 (for-each
			  (lambda (sym)
			    (let ([name #f]
				  [alias #f] )
			      (cond [(pair? sym)
				     (##sys#check-syntax 'import sym '(symbol symbol) clause)
				     (set! name (##sys#slot sym 0))
				     (set! alias (##sys#slot (##sys#slot (##sys#slot sym 1) 0) 1)) ]
				    [else
				     (##sys#check-syntax 'import sym 'symbol clause)
				     (set! name sym)
				     (set! alias (##sys#slot sym 1)) ] )
			      (update!
			       alias
			       (if mexports
				   (let loop ([exps mexports])
				     (if (null? exps)
					 (err "can not import - symbol not exported from module" name m)
					 (let* ([exp (##sys#slot exps 0)]
						[sexp (if (pair? exp) (##sys#slot exp 0) exp)]
						[aexp (if (pair? exp) (##sys#slot exp 1) exp)] )
					   (if (eq? name sexp)
					       aexp
					       (loop (##sys#slot exps 1)) ) ) ) )
				   (begin
				     (set! unr (cons name unr))
				     (##sys#string->symbol (string-append mprefix (##sys#slot name 1)) ) ) )
			       m) ) )
			  syms) ) )
		   (when (pair? unr) 
		     (set! ##sys#unresolved-imports (cons (list m name unr) ##sys#unresolved-imports)) ) ) )
	       (##sys#slot clause 1) ) ]
	     [(import-excluding)
	      (##sys#check-syntax 'import-excluding clause '(_ . #(_ 0)) clause)
	      (for-each
	       (lambda (imp)
		 (when (symbol? imp) (set! imp (list imp)))
		 (##sys#check-syntax 'import-excluding imp '(symbol . #(symbol 0)))
		 (let* ([m (##sys#slot imp 0)]
			[mstr (##sys#slot m 1)]
			[syms (##sys#slot imp 1)]
			[mdef (assq m ##sys#module-list)] )
		   (unless mdef (err "can not import - module is not defined" m))
		   (unless (memq m used) 
		     (let ([u (findunit m)])
		       (when u (set! used (append used (list u)))) ) )
		   (for-each
		    (lambda (exp)
		      (let ([sym (if (pair? exp) (##sys#slot exp 0) exp)]
			    [name (if (pair? exp) (##sys#slot exp 1) exp)] )
			(unless (memq sym syms)
			  (update! (##sys#slot sym 1) name m) ) ) )
		    (##sys#slot mdef 1) ) ) )
	       (##sys#slot clause 1) ) ]
	     [(files)
	      (let ([fs (##sys#slot clause 1)])
		(##sys#check-syntax 'files clause '(_ . #(string 1)) clause)
		(set! files (append files fs)) ) ]
	     [(begin)
	      (set! forms-used #t)
	      (set! files (append files (list (##sys#slot clause 1)))) ]
	     [(unit)
	      (##sys#check-syntax 'unit clause '(_ symbol) clause)
	      (let ([uname (##sys#slot (##sys#slot clause 1) 0)])
		(set! unit uname)
		(set! ##sys#module-unit-map
		  (cons (cons name (##sys#slot (##sys#slot clause 1) 0)) ##sys#module-unit-map) ) ) ]
	     [else (err "invalid clause in module definition" clause name)] ) )
	 clauses)

	(set-cdr! mdef exports)
	(when forms-used
	  (set! itab (make-vector namespace-size '()))
	  (for-each
	   (lambda (imp)
	     (let* ([str (##sys#slot imp 0)]
		    [sym (##sys#slot imp 1)]
		    [i (hashs str)] )
	       (##sys#setslot itab i (cons (cons str sym) (##sys#slot itab i) ) ) ) )
	   imports) )
	(let ([unr (assq name ##sys#unresolved-imports)]
	      [body
	       (builder
		used files unit prefix imports
		(map (lambda (f)
		       (if (list? f)
			   `(begin ,@(qualify-forms f))
			   `(##core#include ',f) ) )
		     files) ) ] )
	  (when unr
	    (let loop ([us (##sys#slot (##sys#slot (##sys#slot unr 1) 1) 0)])
	      (unless (null? us)
		(let ([nm (##sys#slot us 0)])
		  (unless (assq nm exports)
		    (err "previously imported name not exported" nm (##sys#slot (##sys#slot unr 1) 0) name) )
		  (loop (##sys#slot us 1)) ) ) ) )
	  #;(pretty-print body)
	  (expander body) ) ) ) ) )

(define (##sys#default-module-form-builder used files unit prefix imports body)
  `(begin
     (declare (uses ,@used))
     ,@(if (and (pair? files) unit)
	   `((declare (unit ,unit)))
	   '() )
     (##core#elaborationtimeonly (##sys#setup-reader-namespace ',prefix ',imports))
     (##core#enable-unqualified-quoted-symbols)
     ,@body
     (##core#disable-unqualified-quoted-symbols)
     (##core#elaborationtimeonly (##sys#restore-reader-namespace)) ) )

(define ##sys#setup-reader-namespace
  (let ([make-vector make-vector]
	[register-feature! register-feature!] )
    (lambda (prefix imports)
      (define (hashs str)
	(##core#inline "C_fixnum_modulo" (##core#inline "C_hash_string" str) namespace-size) )
      (set! ##sys#enable-qualifiers #f)
      (set! ##sys#processing-module-definition #t)
      (set! ##sys#default-namespace-prefix prefix)
      (set! ##sys#current-namespace (make-vector namespace-size '()))
      (register-feature! #:use-modules)
      (for-each
       (lambda (imp)
	 (let* ([str (##sys#slot imp 0)]
		[sym (##sys#slot imp 1)]
		[i (hashs str)] )
	   (##sys#setslot ##sys#current-namespace i (cons (cons str sym) (##sys#slot ##sys#current-namespace i) ) ) ) )
       imports) ) ) )

(define ##sys#restore-reader-namespace
  (let ([unregister-feature! unregister-feature!])
    (lambda ()
      (set! ##sys#enable-qualifiers #t)
      (set! ##sys#current-namespace #f)
      (set! ##sys#default-namespace-prefix #f)
      (set! ##sys#processing-module-definition #f) 
      (unregister-feature! #:use-modules) ) ) )

(define ##sys#load-interface-repository
  (let* ([file-exists? file-exists?]
	 [string-append string-append] 
	 [getenv getenv] 
	 [pds (string pathname-directory-separator)] 
	 [loadif 
	  (lambda (prefix fn)
	    (and-let* ([prefix]
		       [fn2 (string-append prefix pds fn)]
		       [(file-exists? fn2)] )
	      (##sys#load fn2 #f #f) ) ) ] )
    (lambda ()
      (set! ##sys#repository-loaded #t)
      (let ([fn interface-repository-filename])
	(or (loadif (getenv "HOME") fn)
	    (loadif (getenv "CHICKEN_HOME") fn) ) ) ) ) )

(define (##sys#unqualify-quoted-symbols x)
  (let walk ([x x])
    (cond [(symbol? x) (##sys#intern-symbol (##sys#symbol->string x))]
	  [(##core#inline "C_blockp" x)
	   (if (##core#inline "C_byteblockp" x)
	       x
	       (let ([n (##sys#size x)])
		 (do ([i (if (##core#inline "C_specialp" x) 1 0) (fx+ i 1)])
		     ((fx>= i n) x)
		   (##sys#setslot x i (walk (##sys#slot x i))) ) ) ) ]
	  [else x] ) ) )
