/* scheme-r5rs.c - Small stub that invokes the Chicken interpreter - felix 
   
   Usage: scheme-r5rs SCRIPTFILENAME ARGUMENT1 ...

   - Runs 'csi' with the given arguments like this:

     csi -quiet -batch -hygienic SCRIPTFILENAME -no-init -strict -eval "(##sys#script-main 11)" -- ARGUMENT1 ...
*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>


#define PREFIX_ARGS        10
#define SCRIPT_ARG         4
#define CMD_PARAMETER      "(##sys#script-main 4 11)"


int main(int argc, char *argv[])
{
  char *argsin[] = { "csi", 
		     "-quiet", "-batch", "-hygienic",
		     "",
		     "-no-init", "-strict",
		     "-eval", CMD_PARAMETER,
		     "--" },
       **args = (char **)malloc(argc + 11);
  int i;

  if(args == NULL) {
    fprintf(stderr, "%s: out of memory\n", argv[ 0 ]);
    exit(1);
  }

  if(argc < 2) {
    fprintf(stderr, "%s: no script to run\n", argv[ 0 ]);
    exit(1);
  }

  for(i = 0; i < PREFIX_ARGS; ++i)
    args[ i ] = argsin[ i ];

  for(i = 1; i < argc; ++i)
    args[ i + PREFIX_ARGS - 1 ] = argv[ i ];

  args[ SCRIPT_ARG ] = argv[ 1 ];
  args[ argc + PREFIX_ARGS - 1 ] = NULL;
  i = execvp("csi", args);
  fprintf(stderr, "%s: can not execute interpreter: %s\n", argv[ 0 ], strerror(errno));
  exit(1);
}
