/*
 * loader/initrd.S
 *
 * Initial ramdisk loader
 *
 * This file is a part of Choose-OS. See the file README
 *
 * Copyright (c) Tuomo Valkonen 1997-1998.
 */

#ifdef SUPPORT_INITRD

initrd_addr:	.long	0
initrd_size:	.long	0

// Put initrd data in setupseg
////////////////////////////////
li_setup_initrd:

	mov	eax,dword ptr initrd_addr
	seg	es
	mov	dword ptr [LI_INITRD_ADDR_OFF],eax

	mov	eax,dword ptr initrd_size
	seg	es
	mov	dword ptr [LI_INITRD_SIZE_OFF],eax

	ret
	
// load initial ramdisk
/////////////////////////
li_load_initrd:
	mov	si,#str_loading_initrd
	CALL(print)
	
	xor	eax,eax
	mov	ax,word ptr [LI_RD_SIZE_OFF]
	shl	eax,#9
	mov	dword ptr initrd_size,eax
	
	mov	eax,dword ptr [LI_RD_ADDR_OFF]
	cmp	eax,#0xffffffff
	jne	li_initrd_not_on_top
	call	calc_initrd_addr
	
li_initrd_not_on_top:
	mov	dword ptr initrd_addr,eax

	// set the address in the GDT
	mov	word ptr copy_dst_base,ax
	shr	eax,#16
	mov	byte ptr copy_dst_base+2,al
	mov	byte ptr copy_dst_base24,ah

	mov	dl,[LI_RD_DEV_OFF]
	mov	drive,dl
	
	mov	ax,[LI_RD_MAP_OFF]
	mov	dx,[LI_RD_MAP_OFF+2]
	CALL(load_map)
	
	mov	bx,#SYSSEG
	mov	es,bx
	xor	bx,bx
	mov	di,#MAP_OFF
	mov	byte ptr load_high,#1
	
	CALL(load_it)
	CALL(crlf)
	
	ret

// Calculate address for ramdisk loaded on top of memory
//////////////////////////////////////////////////////////
calc_initrd_addr:
	xor	eax,eax
	mov	ax,#0x8800
	int	#0x15
	
	shl	eax,#10
	add	eax,#0x100000
	
	sub	eax,initrd_size
	and	eax,#0xfffff000		// Page align it...
	// jl initrd_nomem
	
	cmp	eax,#0x200000
	jb	initrd_nomem
	
	ret

initrd_nomem:
	mov	si,#str_initrd_nomem
	CALL(print)
initrd_4ever:
	hlt
	jmp	initrd_4ever
	

// Data
/////////

str_loading_initrd:
		.ascii 	"Loading initrd..."
		.byte	0
		
str_initrd_nomem:
		.ascii	"Outta memory!"
		.byte	0

#endif /* SUPPORT_INITRD */