/*
 * Copyright 2008 The Native Client Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 */

/*
 * Wrapper for syscall.
 */

#include <errno.h>
#include <sys/types.h>
#include <sys/nacl_syscalls.h>

#include "native_client/src/untrusted/nacl/syscall_bindings_trampoline.h"

struct dirent;

int getdents(int desc, struct dirent *dirp, size_t count) {
  int retval = NACL_SYSCALL(getdents)(desc, dirp, count);
  if (retval < 0) {
    errno = -retval;
    return -1;
  }
  return retval;
}
