(in-package :cluei)

(defgeneric deallocate-event (event))

(defgeneric contact-callbacks (c))
(defgeneric (setf contact-callbacks) (nv c))
(defgeneric contact-compress-exposures(c))
(defgeneric contact-compress-motion(c))
(defgeneric contact-event-mask(c))
(defgeneric (setf contact-event-mask)(nv c))
(defgeneric contact-sensitive (c))
(defgeneric (setf contact-sensitive)(nv c))
(defgeneric contact-border-width(c))
(defgeneric contact-background(c))
(defgeneric (setf contact-background)(nv c))
(defgeneric contact-depth (c))
(defgeneric contact-height (c))
(defgeneric contact-width (c))
(defgeneric contact-x (c))
(defgeneric contact-y (c))



(defgeneric contact-resource-parent (contact))
(defgeneric find-contact (parent &key name class))
(defgeneric owns-focus-p (contact))
(defgeneric default-options (class-name options))
(defgeneric add-to-parent (contact))
(defgeneric update-tree (composite))
(defgeneric initial-state-transition (contact))
(defgeneric contact-root (contact))
(defgeneric (setf contact-priority)(nv contact &optional sibling))
(defgeneric initialize-resource-slots (contact table defaults))

(defgeneric contact-state (c))
(defgeneric (setf contact-state)(nv c))
(defgeneric destroy (c))
(defgeneric display (c &optional x y w h &key))
(defgeneric accept-focus-p (c))
(defgeneric preferred-size (c &key))
(defgeneric realize (c))
(defgeneric move(c x y))
(defgeneric resize (c w h bw))
(defgeneric inside-contact-p (c x y))

(defgeneric perform-callback (c name &rest rest))
(defgeneric describe-action (c &rest rest))
(defgeneric eval-action (c &rest rest))
(defgeneric apply-action (c function &rest rest))
(defgeneric throw-action (c tag &optional value))
(defgeneric trace-action (c &rest rest))
(defgeneric ignore-action (c))

(defgeneric handle-event (c e))

(defgeneric composite-children (c))
(defgeneric composite-focus(c))
(defgeneric composite-shells(c))
(defgeneric add-child(c child &key))
(defgeneric delete-child (c child &key))
(defgeneric (setf contact-parent)(nv c &key x y))
(defgeneric manage-geometry
	    (composite contact x y width height border-width &key))
(defgeneric manage-priority(composite contact priority sibling &key))
(defgeneric change-layout(composite &optional changed-child))
(defgeneric initialize-geometry(composite))
(defgeneric move-focus(composite &optional direction &key start revert-to))

(defgeneric convert(contact value type))
(defgeneric translate-key (contact event))

(defgeneric shell-owner(shell))
(defgeneric shell-mapped(shell))
(defgeneric shell-unmapped(shell))
(defgeneric shell-hints(shell))
(defgeneric (setf shell-hints)(nv shell))
(defgeneric shell-normal-hints (shell))
(defgeneric (setf shell-normal-hints)(nv shell))

(defgeneric wm-protocols-used (shell))
(defgeneric (setf wm-protocols-used) (nv shell))
(defgeneric wm-title (shell))
(defgeneric (setf wm-title) (nv shell))
(defgeneric wm-base-height (shell))
(defgeneric (setf wm-base-height) (nv shell))
(defgeneric wm-base-width (shell))
(defgeneric (setf wm-base-width)(nv shell))

(defgeneric wm-delta-height (wm-shell))
(defgeneric (setf wm-delta-height) (nv wm-shell))
(defgeneric wm-delta-width (wm-shell))
(defgeneric (setf wm-delta-width)(nv wm-shell))
(defgeneric wm-gravity (wm-shell))
(defgeneric (setf wm-gravity)(nv wm-shell))
(defgeneric wm-max-aspect (wm-shell))
(defgeneric (setf wm-max-aspect) (nv wm-shell))
(defgeneric wm-max-height (wm-shell))
(defgeneric (setf wm-max-height) (nv wm-shell))
(defgeneric wm-max-width (wm-shell))
(defgeneric (setf wm-max-width) (nv wm-shell))
(defgeneric wm-min-aspect (wm-shell))
(defgeneric (setf wm-min-aspect) (nv wm-shell))
(defgeneric wm-min-height (wm-shell))
(defgeneric (setf wm-min-height) (nv wm-shell))
(defgeneric wm-min-width (wm-shell))
(defgeneric (setf wm-min-width) (nv wm-shell))
(defgeneric wm-user-specified-position-p (wm-shell))
(defgeneric (setf wm-user-specified-position-p) (nv wm-shell))

(defgeneric wm-user-specified-size-p (wm-shell))
(defgeneric (setf wm-user-specified-size-p) (nv wm-shell))
(defgeneric wm-group (wm-shell))
(defgeneric (setf wm-group)(nv wm-shell))
(defgeneric wm-initial-state (wm-shell))
(defgeneric (setf wm-initial-state) (nv wm-shell))
(defgeneric wm-keyboard-input (wm-shell))
(defgeneric (setf wm-keyboard-input) (nv wm-shell))
(defgeneric wm-colormap-owners (tls))
(defgeneric (setf wm-colormap-owners) (nv tls))
(defgeneric wm-icon-title (tls))
(defgeneric (setf wm-icon-title)(nv tls))
(defgeneric wm-icon (tls))
(defgeneric (setf wm-icon)(nv tls))
(defgeneric wm-icon-mask (tls))
(defgeneric (setf wm-icon-mask) (nv tls))
(defgeneric wm-icon-x (tls))
(defgeneric (setf wm-icon-x) (nv tls))
(defgeneric wm-icon-y (tls))
(defgeneric (setf wm-icon-y)(nv tls))

(defgeneric wm-change-class (shell))
(defgeneric wm-change-client-mashine(tls))
(defgeneric wm-change-colormap-windows(tls))
(defgeneric wm-change-command(tls))
(defgeneric wm-change-hints (tls))
(defgeneric wm-change-icon-name (tls))
(defgeneric wm-change-name (tls))
(defgeneric wm-change-normal-hints (tls))
(defgeneric wm-change-protocols (tls))
(defgeneric wm-take-focus (tls))

(defgeneric sm-client-host (tls))
(defgeneric (setf sm-client-host) (nv tls))
(defgeneric sm-command (tls))
(defgeneric (setf sm-command)(nv tls))
