/*
	The minimum requirements needed by every ClanLib application.

	note that the try/catch is not required but should be added 
	to every ClanLib application.
*/

#include <ClanLib/core.h>
#include <ClanLib/magick.h>

class MagickApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "ImageMagick application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
		CL_SetupMagick::init();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
		CL_SetupMagick::deinit();
	}

	virtual int main(int, char **)
	{
		CL_SetupCore::init_display();
		try
		{
			// Set mode: 640x480 16 bpp
			CL_Display::set_videomode(640, 480, 16, true);
		
			//creat a new surface and load a image to it
			CL_Surface *surf = CL_MagickProvider::create("../AlphaTest/back.jpg", NULL);

			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
			
				//Put image to screen
				surf->put_screen(0, 0);
			
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
			
				// Update keyboard input and handle system events:
				CL_System::keep_alive();
			}
		
			std::cout << "Exiting" << std::endl;
		}
		catch (CL_Error err)
		{
			std::cout << "Exception caught: " << err.message.c_str() << std::endl;
			return -1;
		}
		return 0;
	}
} app;
