/*
	NetObjects demonstration application.

	Copyright (c)1999 by Magnus Norddahl / ClanSoft.
*/

#include <ClanLib/core.h>

class MouseCursor;

class NetObjectsDemo : public CL_ClanApplication, CL_NetObjectCreator
{
public:
	virtual char *get_title();
	virtual int main(int argc, char **argv);

	void init_modules();
	void deinit_modules();
	
	void create_game();
	void join_game();
	void run_game();
	
	virtual CL_NetObject *create(
		int netobj_id,
		CL_InputSource *input);

	MouseCursor *cursor;
	CL_NetObjectController_Basic *cursor_controller;
	CL_NetGame *netgame;
};

class MouseCursor : public CL_NetObject
{
public:
	MouseCursor(NetObjectsDemo *app);
	MouseCursor(NetObjectsDemo *app, CL_InputSource *input);
	virtual ~MouseCursor();

	void show();
	
	CL_NetMessage write_message();
	virtual void receive_message(CL_InputSource *input);

private:
	void init(NetObjectsDemo *app);

	int x, y;
	float red, green, blue;
	bool master;

	NetObjectsDemo *app;
};
