/*
	$Id: provider_fli.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Fli/Flc reader.

*/

//! component="SurfaceProviders"

#ifndef header_flicprovider
#define header_flicprovider

#include "generic_surfaceprovider.h"

#define CHUNK_FLC_256COLOR	 4
#define CHUNK_FLC_DELTA			 7
#define CHUNK_FLI_COLOR		11
#define CHUNK_FLI_LC		12
#define CHUNK_FLI_BLACK		13
#define CHUNK_FLI_BRUN		15
#define CHUNK_FLI_COPY		16
#define CHUNK_FLC_MINI		18

class CL_FLIProvider : public CL_SurfaceProvider_Generic
//: A surface provider that can show FLi/FLc animations.
{
	struct SFLIHeader
	{
		int size;
		unsigned short magic;
		unsigned short num_frames;
		unsigned short width, height, bpp, flags, speed;
		int next, frit;
	};

	struct SFLIFrameHeader
	{
		int size;
		unsigned short magic, num_chunks;
	};

	struct SFLIChunkHeader
	{
		int size;
		unsigned short type;
	};
	
	CL_Palette *pal;
	int start_frame;

	unsigned char *fli_start;
	unsigned char *fli_buffer;
	unsigned char *loop_pos;
	unsigned char *output_buffer;
	int cur_frame;

	SFLIHeader *header;

	void read_color(int shift_amount);
	void read_lc();
	void read_black();
	void read_brun();
	void read_copy();
	void read_delta();

	int width, height, transcol;

public:
	static CL_Surface *create(char *fliname)
	{
		return CL_Surface::create(new CL_FLIProvider(fliname, 0), true);
	}
	//: Creates a surface using the FLi/FLc file 'fliname' as source.
	//!param: fliname - The .flc / .fli file to use.

	static CL_Surface *create(char *fliname, int frameno)
	{
		return CL_Surface::create(new CL_FLIProvider(fliname, frameno), true);
	}
	//: Creates a surface using the FLi/FLc file 'filename' as source and 
	//: 'frameno' as start frame.


	CL_FLIProvider(const char *fli_file, int start_frame);
	//: Constructs a surfaceprovider using the FLi/FLc file 'fli_file' as source, 
	//: starting at frame 'start_frame'.
	//!param: fli_file - .flc / .fli file to use.
	//!param: start_frame - Initial frame to be delivered by the surface provider.
	
	virtual ~CL_FLIProvider();

	virtual unsigned int get_width() const;
	//: Returns the width of the image.
	
	virtual unsigned int get_height() const;
	//: Returns the height of the image.

	virtual unsigned int get_num_frames() const;
	//: Returns the number of subsprites in the image.

	virtual unsigned int get_red_mask() const;
	//: Returns the red color mask.

	virtual unsigned int get_green_mask() const;
	//: Returns the green color mask.

	virtual unsigned int get_blue_mask() const;
	//: Returns the blue color mask.

	virtual unsigned int get_alpha_mask() const;
	//: Returns the alpha color mask.
	
	virtual CL_Palette *get_palette() const;
	//: Returns the palette used by the image. NULL if system palette.
	
	virtual unsigned int get_pitch() const;
	virtual unsigned int get_depth() const;
	virtual bool is_indexed() const;
	
	virtual bool uses_src_colorkey() const;
	//: Returns true if provider uses a source color key.
	
	virtual unsigned int get_src_colorkey() const;
	//: Returns the transparency color used the image.

	virtual void *get_data() const;
	//: Returns a pointer to the image data. Must be locked before data is valid.

	virtual void perform_lock();
	//: Locks the surface provider.
	
	virtual void perform_unlock();
	//: Unlocks the surface provider.
};

#endif
