/*
	$Id: sprite.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Simple sprite support.

*/

//! component="SurfaceProviders"

#ifndef header_sprite
#define header_sprite

#include "generic_surfaceprovider.h"
#include "../IOData/inputsource.h"
#include "../IOData/inputsource_provider.h"

/*
CreateError(CL_Error_ClanLib_Sprite, CL_Error_ClanLib, "ClanLib sprite error")
CreateError(CL_Error_ClanLib_Sprite_Load, CL_Error_ClanLib_Sprite, "Error while loading sprite")
*/
class CL_SpriteProvider : public CL_SurfaceProvider_Generic
//: ClanLib datafile sprite. Used to load surfaces stored in ClanLib's datafile 
//: sprite format.
{
protected:
	std::string surface_id;
	CL_InputSourceProvider *provider;
	void *surface_data;
	int width, height, no_sprs, transcol;
	CL_Palette *palette;
	unsigned int red_mask, green_mask, blue_mask, alpha_mask;
	unsigned int bpp;
	bool m_is_indexed;

	void load_data();

public:
	static CL_Surface *create(const char *surface_id, CL_InputSourceProvider *datafile);
	//: Loads the sprite 'surface_id' from the inputsource provider 'datafile'. 
	//: Creates a surface using this sprite (surfaceprovider) and returns it.
	//: <br>
	//: This function is a easier way of typing: <br>
	//: CL_Surface::create(new CL_Sprite(surface_id, datafile), true);

	CL_SpriteProvider(const char *surface_id, CL_InputSourceProvider *datafile);
	//: Constructs a surface provider that represents the sprite 'surface_id' 
	//: from the inputsource provider 'datafile'.

	virtual ~CL_SpriteProvider();

	virtual unsigned int get_width() const;
	//: Returns the width of the sprite.

	virtual unsigned int get_height() const;
	//: Returns the height of the sprite.

	virtual unsigned int get_pitch() const;
	//: Returns the pitch of the sprite.
	
	virtual unsigned int get_num_frames() const;
	//: Returns the number of subsprites in this sprite.
	
	virtual CL_Palette *get_palette() const;
	//: Returns the palette used by the surface. NULL if the system palette is 
	//: used.

	virtual bool uses_src_colorkey() const;
	virtual unsigned int get_src_colorkey() const;
	//: Returns the transparency color used, or -1 if none.
	
	virtual unsigned int get_red_mask() const;
	virtual unsigned int get_green_mask() const;
	virtual unsigned int get_blue_mask() const;
	virtual unsigned int get_alpha_mask() const;
	virtual unsigned int get_depth() const;
	virtual bool is_indexed() const;
	
	virtual void *get_data() const;
	//: Returns a pointer to the sprites image data. Can only be called between 
	//: lock() and unlock().

	virtual void perform_lock();
	//: Locks the surface provider. This causes the sprite to retrieve its 
	//: surface data from the datafile.
	
	virtual void perform_unlock();
	//: Unlocks the surface provider. The sprite releases its surface data when
	//: it is called.
};
/*
class CL_SpriteTexture : public CL_TextureProvider
//: ClanLib datafile texture. Used to load textures stored in ClanLib's datafile 
//: sprite format.
{
protected:
	std::string surface_id;
	CL_InputSourceProvider *provider;
	void *surface_data;
	int width, height, no_sprs, transcol;
	CL_Palette *palette;
	EPixelFormat pixelformat;

	void load_data();

public:
	static CL_Texture *load(char *surface_id, CL_InputSourceProvider *datafile);
	//: Loads the texture 'surface_id' from the inputsource provider 'datafile'. 
	//: Creates a texture using this sprite (textureprovider) and returns it.
	//: <br>
	//: This function is a easier way of typing: <br>
	//: <code>CL_Texture::create(new CL_SpriteTexture(surface_id, datafile), true);</code>

	CL_SpriteTexture(char *surface_id, CL_InputSourceProvider *datafile);
	//: Constructs a texture provider that represents the sprite 'surface_id' 
	//: from the inputsource provider 'datafile'.

	virtual ~CL_SpriteTexture();

	virtual unsigned int get_width();
	//: Returns the width of the sprite.

	virtual unsigned int get_height();
	//: Returns the height of the sprite.

	virtual unsigned int get_no_mipmaps() { return 1; }
	//: Returns the number of mipmaps in the sprite.

	virtual EPixelFormat get_pixel_format();
	//: Returns the pixel format used by the sprite.

	virtual CL_Palette *get_palette();
	//: Returns the palette used by the texture. NULL if the system palette is 
	//: used.

	virtual int get_transcol();
	//: Returns the transparency color used, or -1 if none.

	virtual void *get_data();
	//: Returns a pointer to the sprites image data. Can only be called between 
	//: lock() and unlock().

	virtual void lock();
	//: Locks the texture provider. This causes the sprite to retrieve its 
	//: surface data from the datafile.

	virtual void unlock();
	//: Unlocks the texture provider. The sprite releases its surface data when
	//: it is called.
};
*/
#endif
