/*
	$Id: clanapp.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="System"

#ifndef header_clanapp
#define header_clanapp

class CL_ClanApplication
//: The starting place for all applications.
// The application class must be inherited by all ClanLib applications.
// In your application create a class inheriting CL_ClanApplication, 
// make a global instance of it, and fill in the main() and get_title() functions.
{
public:
	CL_ClanApplication();
	virtual ~CL_ClanApplication();

	virtual char *get_title()=0;
//: Every program made using ClanLib must implement this function. 
//: It returns the title of the application, which depending 
//: on the platform on which it is run, will be passed on 
//: to the operating system.
//!retval: The application title

	virtual void init_modules()=0;
// Before main() is called, or before the datafile compiler is invoked,
// this function gets called. Use it to initialize libraries.

	virtual void deinit_modules()=0;
// Called after main() or after the datafile compiler completes. Use it
// to shutdown libraries.

	virtual int main(int argc, char** argv)=0;
//: Every program made using ClanLib must implement this function. 
//: This is the main application function, which will be called 
//: _once_ following system initialization.
//!param: argc - The number of arguments to the program (c-style)
//!param: argv - A pointer to strings, containing the program arguments. The name of the program executable is always passed as first argument.
//!retval: Program return value

	static CL_ClanApplication *app;
//: Static pointer to an initialized instance of this class. This is set by the 
//: constructor.
};

#endif