/*
	$Id: cl_gwidget.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GWIDGET_H
#define CL_GWIDGET_H

#include "../core.h"
#include "cl_gobject.h"
#include "cl_grect.h"
#include "cl_gevent.h"
#define NOTRACE
#include "trace.h"

///
class CL_GWidget : public CL_GObject, public CL_GRect
{
public:

  ///
  CL_GWidget();
  ///
  CL_GWidget(CL_GWidget* parent, int x, int y, int w, int h);
  ///
  virtual ~CL_GWidget();
  ///

  /**setting background image.
     the surface is NOT copied. you will have to ensure it is accesible
     as long as this widget lives. (use UResources...)
  */
  void setBackground(const CL_Surface* backgrnd, bool tileIt = true);
  ///setting background color.
  //void setColor(const UColor &color);
  void setColor(float r, float g, float b, float a);
  ///
  void setAlpha(unsigned char);

  ///screen update
  virtual void update();
  ///show up this widget and its childs.
  void show();
  ///hide this widget and its childs.
  void hide();
  ///close  this widget and its childs.
  void close();
  ///enable this widget tree
  void enable();
  /**disable this widget tree.
     The widget tree gets greyed and the member ignore any events.
  */
  void disable();

  virtual void resize(int w, int h)
    { /*
      CL_GRect::resize(w,h);
      //FIXME !!!!!!!!!!!
      //being very crude here ... (it is 1:00am)
      delete surface_;
      surface_ = new USurface(w,h);
      rect_.resize(w,h);
      window_.resize(w,h);
      needsUpdate_=true;*/
      };
  ///
  DEF_SLOT_1(forceUpdate, int);
  ///
  DEF_SLOT_1(close, int);
  ///
  DEF_SLOT_1(hide, int);
  ///
  DEF_SLOT_1(show, int);

  /** just blit to the parents surface.
   */
  void blit();
  ///
  bool handleEvent(const CL_GEvent*);
  ///
  virtual bool processEvent(const CL_GEvent*) { return false;};

  /**widget content has changed.
     this is called by the mainloop or parentwidget to test,
     whether this widget or one of its childs have to be reblitted.
  */
  bool needsUpdate();

  ///
  bool isHidden() { return hidden_; };
  ///
  bool isClosed() { return closed_; };
  ///
  bool isEnabled() { return !disabled_; };

  /**insert a child widget.
     this is only to be called from the constructor of a childwidget.
     it will return the surface the child has to blit its own surface to
  */
  CL_Surface* insertChild(CL_GWidget* child);

  ///
  void removeChild(CL_GWidget* child);

  /**return geometry.
   */
  CL_GRect getRect() { return rect_ ;};

  /**convert rect coords to global rect coords.
   */
  CL_GRect globalCoord(CL_GRect);
  /**convert global rect coords to local rect coords.
   */
  CL_GRect localCoord(CL_GRect);

  ///
  void addUpdateRects(std::list<CL_GRect> &updateRects);

 protected:

  /**create the widget and childs.
     must be overloaded by derived classes to implemented their
     own grafx, etc.
     (each derived class may call the baseclasss create to handle
     the basic stuff like background painting)
  */
  virtual void create();

  ///
  virtual void initMembers();

  /**blit whole widget.
     descendants may overwrite this in order to implement special
     blits. This methode gets called, if the whole widget needs to
     be redrawn to the screen.
     The target is usually the screenbuffer.
   */
  virtual void blit_complete(CL_Surface*);

  /**blit only dirty rects.
     descendants may overwrite this in order to implement special
     blits. Check` dirtyRects to see what parts need to be reblitted.
     The target is usually the screenbuffer.
  */
  virtual void blit_dirty(CL_Surface*);

  /**the parent.
     if NULL this widget is  toplevel
  */
  CL_GWidget *parent_;
  /**destination rectangle.
     the coords are relative to the parents coords.
   */
  CL_GRect rect_;
  /**window rect.
     if local surface is bigger than destination rect; only this
     window is blitted.
  */
  CL_GRect window_;
  /**background image.
     may be NULL
  */
  const CL_Surface *backgrnd_;
  /**surface buffer.
   */
  CL_Surface *surface_;
  //CL_Canvas *surface_canvas;
  /**destination surface.
     this widgets blits to this surface, whenever show is called
  */
  CL_Surface *parentSurface_;
  //CL_Canvas *parentCanvas;
  /**backbuffer.
     stores background of transparent widgets.
  */
  CL_Surface *backBuffer_;

  ///background color.
  //UColor color_;
  float r, g, b, a;

  ///true when the mouse is over this widget
  bool haveFocus_;
  ///have we got a background surface ?
  bool drawBackground_;
  /**true if this widgets needs to be reblitted to its parents surface.
     a derived widget simply set this to true in order to get redrawn.
     This is handled completely by the baseclass.
  */  
  bool use_color_;
  ///
  bool needsUpdate_;
  ///
  bool needsReblit_;
  ///
  bool hidden_;
  ///
  bool hideRequest_;
  ///
  bool closed_;
  ///
  bool disabled_;
  ///
  bool disableRequest_;
  /// self delete when closing ?
  bool destroyWidget_;

  /**create child widget.
   */
  void createChild();

  ///child list.
  std::list<CL_GWidget*> childs_;

  /**list of dirty rects.
     this is used for faster redrawing; especially if the toplevel-
     widgets is big and only a small child-widgets needs to be redrawn.
  */
  std::list<CL_GRect> dirtyRects_;
  ///
  bool tileBackground_;

};

#endif
