/*
	$Id: mpeg_soundprovider.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_mpeg_soundprovider
#define header_mpeg_soundprovider

#include "../Core/Sound/stream_soundprovider.h"
#include "../stl.h"
#include <MPEG/MPEG.h>

class CL_MPEGSoundProvider : public CL_StreamSoundProvider
//: Streamed MPEG audio stream sound provider.
{
public:
	CL_MPEGSoundProvider(const char *filename);
	virtual ~CL_MPEGSoundProvider();

	virtual CL_StreamSoundProvider_Session *begin_session();
	virtual void end_session(CL_StreamSoundProvider_Session *session);

private:
	std::string file;
};

class CL_MPEGSoundProvider_Session : public CL_StreamSoundProvider_Session, MPEGAudioDrv
{
public:
	CL_MPEGSoundProvider_Session(const char *filename);
	virtual ~CL_MPEGSoundProvider_Session();

	virtual bool eof() const;
	//: Returns true if no more input data is available.
	//!retval: True if end of input data. False otherwise.
	
	virtual void stop();
	//: Stops the current stream.

	virtual bool play();
	//: Start/continue playing of the stream.
	//!retval: True for success. False otherwise.
		
	virtual bool set_position(int pos);
	//: Sets the position within the current stream.
	//!param: pos - Position to seek to.
	//!retval: True for success. False otherwise.
	
	virtual int get_data(void *data_ptr, int data_requested);
	//: Called when a playback session needs more sample data.
	//!param: data_ptr - Points to a buffer that should be filled with
	//!param:            sample data.
	//!param: data_requested - Bytes of data requested.
	//!retval: Number of bytes actually filled with sample data.

	virtual int get_frequency() const;
	//: Returns the playback frequency of the input data.
	//!retval: Playback frequency.

	virtual SoundFormat get_format() const;
	//: Returns the playback sample format.
	//!retval: The playback Sample format.

protected:
	// MPEGAudioDrv interface:
	virtual bool Open(MPEGAudioSpec *desired, MPEGAudioSpec *optained);
	virtual void Close();
	virtual void Pause(bool enable);
	virtual void Mix(Uint8 *dst, Uint8 *src, Uint32 len, int volume);
	virtual void Lock();
	virtual void Unlock();
	virtual int GetMaxVolume();
	virtual char *GetError();

private:
	MPEG *mpeg;
	MPEGAudioSpec audiospec;
};

#endif
