/*
	$Id: inputsource_memory_generic.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <stdio.h>
#include <API/Core/IOData/inputsource.h>
#include "API/Core/System/cl_assert.h"
#include "inputsource_memory_generic.h"

CL_InputSource_MemoryGeneric::CL_InputSource_MemoryGeneric(
	void *data,
	int size,
	bool delete_data)
{
	m_data = (unsigned char *) data;
	m_pos = 0;
	m_size = size;
	m_delete_data = delete_data;
}

CL_InputSource_MemoryGeneric::~CL_InputSource_MemoryGeneric()
{
	if (m_delete_data) delete[] m_data;
}

void CL_InputSource_MemoryGeneric::set_system_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_MemoryGeneric::set_big_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_MemoryGeneric::set_little_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

int CL_InputSource_MemoryGeneric::read_int32()
{
	cl_assert(m_pos+sizeof(int) <= m_size);

	int a = *((int *)(m_data+m_pos));
	m_pos += sizeof(int);
	return a;
}

unsigned int CL_InputSource_MemoryGeneric::read_uint32()
{
	cl_assert(m_pos+sizeof(unsigned int) <= m_size);

	unsigned int a = *((unsigned int *)(m_data+m_pos));
	m_pos += sizeof(unsigned int);
	return a;
}

short CL_InputSource_MemoryGeneric::read_short16()
{
	cl_assert(m_pos+sizeof(short) <= m_size);

	short a = *((short *)(m_data+m_pos));
	m_pos += sizeof(short);
	return a;
}

unsigned short CL_InputSource_MemoryGeneric::read_ushort16()
{
	cl_assert(m_pos+sizeof(unsigned short) <= m_size);

	unsigned short a = *((unsigned short *)(m_data+m_pos));
	m_pos += sizeof(unsigned short);
	return a;
}

char CL_InputSource_MemoryGeneric::read_char8()
{
	cl_assert(m_pos+1 <= m_size);
	return ((char *) m_data)[m_pos++];
}

unsigned char CL_InputSource_MemoryGeneric::read_uchar8()
{
	cl_assert(m_pos+1 <= m_size);
	return m_data[m_pos++];
}

bool CL_InputSource_MemoryGeneric::read_bool()
{
	cl_assert(m_pos+sizeof(bool) <= m_size);

	bool a = *((bool *)(m_data+m_pos));
	m_pos += sizeof(bool);
	return a;
}

float CL_InputSource_MemoryGeneric::read_float32()
{
	cl_assert(m_pos+sizeof(float) <= m_size);

	float a = *((float *)(m_data+m_pos));
	m_pos += sizeof(float);
	return a;
}

int CL_InputSource_MemoryGeneric::read(void *data, int size)
{
	cl_assert(m_pos+size <= m_size);
	
	memcpy(data, m_data+m_pos, size);
	m_pos += size;

	return size;
}

void CL_InputSource_MemoryGeneric::open()
{
	m_pos = 0;
}

void CL_InputSource_MemoryGeneric::close()
{
}

CL_InputSource *CL_InputSource_MemoryGeneric::clone() const
{
	cl_assert(false); // not implemented yet.

	return NULL;
}

int CL_InputSource_MemoryGeneric::tell() const
{
	return m_pos;
}

void CL_InputSource_MemoryGeneric::seek(int pos, SeekEnum seek_type)
{
	switch (seek_type)
	{
	case seek_set:
		m_pos = pos;
		break;
	
	case seek_cur:
		m_pos += pos;
		break;
	
	case seek_end:
		m_pos = m_size+pos;
		break;
	
	default: // invalid seek type!
		cl_assert(false);
	}
}

int CL_InputSource_MemoryGeneric::size() const
{
	return m_size;
}

std::string CL_InputSource_MemoryGeneric::read_string()
{
	int size = read_int32();
	char *str = new char[size];
	read(str, size);
	
	std::string ret = str;
	delete[] str;

	return ret;
}

void CL_InputSource_MemoryGeneric::push_position()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_MemoryGeneric::pop_position()
{
	cl_assert(false); // not implemented yet.
}
