/*
	$Id: resource_manager_file.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_resource_manager_file
#define header_resource_manager_file

#include <API/Core/Resources/resource_manager.h>
#include "resource_tokenizer.h"

#define default_scriptfile_id "_script_section"

class CL_ResourceManager_File : public CL_ResourceManager
{
public:
	CL_ResourceManager_File(
		const char *config_file,
		CL_InputSourceProvider *provider = NULL,
		bool read_directly_from_source=false,
		bool delete_inputsource_provider=false);

	CL_ResourceManager_File(
		const char *file_name,
		const bool is_datafile);

	virtual ~CL_ResourceManager_File();

	virtual void load_all_resources();
	virtual void unload_all_resources();

	virtual void load_section(const char *section_name);
	virtual void unload_section(const char *section_name);

	virtual CL_Resource *get_resource(std::string res_id);
	virtual std::list<std::string> *get_all_resources();
	virtual std::list<std::string> *get_resources_of_type(std::string type_id);

	virtual CL_InputSourceProvider *get_resource_provider();

private:
	void parse();
	void parse_section_body(
		std::string token,
		CL_ResourceTokenizer &lexer,
		std::string prefix);

	CL_Resource *create_resource(
		std::string name,
		std::string location,
		CL_ResourceOptions &options);

	std::list<CL_Resource*> resources;
	CL_InputSourceProvider *resource_provider;

	std::string filename;
	bool from_source;
	bool delete_resource_provider;
};

#endif
