/*
	$Id: resource_manager_net_generic.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_resource_manager_net_generic
#define header_resource_manager_net_generic

#include <API/Core/Resources/resource_manager_net.h>
#include <API/Core/IOData/inputsource_provider.h>
#include <API/Core/IOData/inputsource_memory.h>

class CL_ResourceManager_Net_Generic : public CL_ResourceManager_Net, CL_InputSourceProvider
{
public:
	CL_ResourceManager_Net_Generic();
	virtual ~CL_ResourceManager_Net_Generic();

	// From CL_ResourceManager_Net:
	// ----------------------------

	virtual bool receive(CL_NetGame *net, int netchannel);
	virtual void send(CL_NetGame *net, int netchannel, const CL_NetComputer *comp);
	virtual void send(CL_NetGame *net, int netchannel, const CL_NetGroup *group = NULL);

	virtual void add(CL_Resource *resource);

	// From CL_ResourceManager:
	// ------------------------

	virtual void load_all_resources();  
	virtual void unload_all_resources();  
	virtual void load_section(const char *section_name);  
	virtual void unload_section(const char *section_name);  

	virtual CL_Resource *get_resource(std::string res_id);  
	virtual std::list<std::string> *get_all_resources();  
	virtual std::list<std::string> *get_resources_of_type(std::string type_id);  

	virtual CL_InputSourceProvider *get_resource_provider();  

protected:
	// From CL_InputSourceProvider:
	// ----------------------------

	virtual CL_InputSource *open_source(const char *handle);
	virtual CL_InputSourceProvider *clone();

private:
	// implementation:
	// ---------------

	std::list< std::pair<std::string, CL_InputSource_Memory *> > sources;
	std::list<CL_Resource *> resources;
};

#endif
