/*
	$Id: resourcetype_integer.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Integer resource type

*/

#include "Core/precomp.h"
#include <API/Core/Resources/resourcetype_integer.h>

CL_Res_Integer::CL_Res_Integer() : CL_ResourceType("integer")
{
}

CL_Resource *CL_Res_Integer::create_from_location(
	std::string name,
	std::string location,
	CL_ResourceOptions *options,
	CL_ResourceManager *parent)
{
	return new CL_IntegerResource(name, location, options, parent);
}

CL_Resource *CL_Res_Integer::create_from_serialization(
	std::string name,
	CL_ResourceManager *parent)
{
	return new CL_IntegerResource(name, parent);
}

int CL_Res_Integer::load(
	std::string name,
	CL_ResourceManager *manager,
	int _default)
{
	try
	{
		CL_IntegerResource *res = (CL_IntegerResource *) manager->get_resource(name);
		return res->get_value();
	}
	catch (CL_Error err)
	{
		return _default;
	}
}

int CL_Res_Integer::load(
	std::string name,
	CL_ResourceManager *manager)
{
	CL_IntegerResource *res = (CL_IntegerResource *) manager->get_resource(name);
	return res->get_value();
}
