
#ifndef header_cdaudio_linux
#define header_cdaudio_linux

#include "API/Core/Sound/cd_audio.h"

class CL_CDDrive_Linux : public CL_CDDrive
{
public:
	CL_CDDrive_Linux(const char *filename);
	virtual ~CL_CDDrive() { ; }

	virtual bool init();

	virtual std::string get_drive_path();
	virtual std::string get_cd_name();

	virtual int get_num_tracks();

	virtual bool is_playing();
	virtual int get_cur_track();
	virtual int get_cur_frame();

	virtual bool play_tracks(int track, int end_track);
	virtual bool play_frames(int frame, int end_frame);
	virtual bool play_track(int track);

	virtual void stop();
	virtual void pause();
	virtual void resume();

private:
	std::string filename;
	int file_handle;
};

#endif
