
#include "Core/precomp.h"
#include "API/Core/System/setupcore.h"
#include "Core/Display/Generic/restype_surface.h"
#include "Core/Font/resourcetype_font.h"
#include "API/Core/SurfaceProviders/provider_pcx.h"
#include "API/Core/SurfaceProviders/provider_bmp.h"
#include "API/Core/SurfaceProviders/provider_fli.h"
#include "API/Core/SurfaceProviders/provider_targa.h"
#include "API/Core/SurfaceProviders/provider_ppm.h"
#include "API/Core/Resources/resourcetype_boolean.h"
#include "API/Core/Resources/resourcetype_integer.h"
#include "API/Core/Resources/resourcetype_string.h"
#include "Core/Sound/Generic/resourcetype_sample.h"

static CL_Res_Surface *restype_surface = NULL;
static CL_Res_Font *restype_font = NULL;
static CL_Res_Boolean *restype_boolean = NULL;
static CL_Res_Integer *restype_integer = NULL;
static CL_Res_String *restype_string = NULL;
static CL_Res_Sample *restype_sample = NULL;

static void init_surface_sources();
static void deinit_surface_sources();

void CL_SetupCore::init()
{
	restype_surface = new CL_Res_Surface;
	restype_font = new CL_Res_Font;
	restype_boolean = new CL_Res_Boolean;
	restype_integer = new CL_Res_Integer;
	restype_string = new CL_Res_String;
	restype_sample = new CL_Res_Sample;

	init_surface_sources();
}

void CL_SetupCore::deinit()
{
	deinit_surface_sources();

	delete restype_surface;
	delete restype_font;
	delete restype_boolean;
	delete restype_integer;
	delete restype_string;
	delete restype_sample;

	restype_surface = NULL;
	restype_font = NULL;
	restype_boolean = NULL;
	restype_integer = NULL;
	restype_string = NULL;
	restype_sample = NULL;
}

// Resource support: (sorry for the messy code)

class CL_PCX_ResourceSource : public CL_ResourceSource_Surface
{
public:
	virtual const char *get_name() { return "pcx"; }

	virtual bool can_create(
		std::string ext,
		CL_ResourceOptions *options)
	{
		if (ext == ".pcx") return true;
		if (options->exists("pcx")) return true;
		
		return false;
	}
	
	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)
	{
		return new CL_PCXProvider(filename.c_str(), NULL);
	}
} *pcx_resource_source = NULL;

class CL_BMP_ResourceSource : public CL_ResourceSource_Surface
{
public:
	virtual const char *get_name() { return "bmp"; }

	virtual bool can_create(
		std::string ext,
		CL_ResourceOptions *options)
	{
		if (ext == ".bmp") return true;
		if (options->exists("bmp")) return true;
		
		return false;
	}
	
	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)
	{
		return new CL_BMPProvider(filename.c_str(), NULL);
	}

} *bmp_resource_source = NULL;

class CL_PPM_ResourceSource : public CL_ResourceSource_Surface
{
public:
	virtual const char *get_name() { return "ppm"; }

	virtual bool can_create(
		std::string ext,
		CL_ResourceOptions *options)
	{
		if (ext == ".ppm") return true;
		if (options->exists("ppm")) return true;
		
		return false;
	}
	
	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)
	{
		return new CL_PPMProvider(filename.c_str(), NULL);
	}

} *ppm_resource_source = NULL;

class CL_FLI_ResourceSource : public CL_ResourceSource_Surface
{
public:
	virtual const char *get_name() { return "fli"; }

	virtual bool can_create(
		std::string ext,
		CL_ResourceOptions *options)
	{
		if (ext == ".fli") return true;
		if (ext == ".flc") return true;
		if (ext == "flic") return true;
		if (options->exists("fli")) return true;

		return false;
	}

	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)
	{
		int start_frame = 0;
		
		if (options->exists("start_frame"))
			start_frame = CL_String(options->get_value("start_frame")).get_as_int();

		return new CL_FLIProvider(filename.c_str(), start_frame);
	}

} *fli_resource_source = NULL;

class CL_Targa_ResourceSource : public CL_ResourceSource_Surface
{
public:
	virtual const char *get_name() { return "tga"; }

	virtual bool can_create(
		std::string ext,
		CL_ResourceOptions *options)
	{
		if (ext == ".tga") return true;
		if (options->exists("tga")) return true;

		return false;
	}

	virtual CL_SurfaceProvider *create(
		std::string filename,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent)
	{
		return new CL_TargaProvider(filename.c_str(), NULL);
	}

} *targa_resource_source = NULL;

static void init_surface_sources()
{
	pcx_resource_source = new CL_PCX_ResourceSource;
	bmp_resource_source = new CL_BMP_ResourceSource;
	ppm_resource_source = new CL_PPM_ResourceSource;
	fli_resource_source = new CL_FLI_ResourceSource;
	targa_resource_source = new CL_Targa_ResourceSource;
}

static void deinit_surface_sources()
{
	delete pcx_resource_source;
	delete bmp_resource_source;
	delete ppm_resource_source;
	delete fli_resource_source;
	delete targa_resource_source;

	pcx_resource_source = NULL;
	bmp_resource_source = NULL;
	ppm_resource_source = NULL;
	fli_resource_source = NULL;
	targa_resource_source = NULL;
}
