/* tolua - Support code for Lua bindings.
** Written by Waldemar Celes (celes@tecgraf.puc-rio.br)
** TeCGraf/PUC-Rio
** http://www.tecgraf.puc-rio.br/~celes/tolua
** Jul 1998
** $Id: tolua.h,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it.
** The software provided hereunder is on an "as is" basis, and
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications.
*/


#ifndef tolua_h
#define tolua_h

#define TOLUA_VERSION       "tolua 3.2"


#include <stdlib.h>		/* NULL, malloc, free */

#ifdef __cplusplus
extern "C" {
#endif

#include "lua.h"
#if 0
#include "luatrace.h"
#endif


/*************************************** Exported functions */

int  tolua_open (void);
void tolua_restorestate (void);
void tolua_using (lua_Object module);
void tolua_class (lua_Object derived, lua_Object base);
void tolua_instance (lua_Object instance, lua_Object classobj);
void tolua_foreach (lua_Object lo, lua_Object f);
int  tolua_tag (char* type);
char* tolua_type (lua_Object lo);
lua_Object tolua_base (lua_Object lo);
lua_Object tolua_cast (lua_Object lo, char* type);
void tolua_takeownership (lua_Object lo);



/*************************************** Support functions for binding code */

#define TOLUA_NIL	(lua_pushnil(),lua_pop())

/* Register functions */
void tolua_globalvar (char* name, lua_CFunction get, lua_CFunction set);
void tolua_globalarray (char* name, lua_CFunction get, lua_CFunction set);
void tolua_module (char* name);
void tolua_cclass (char* name, char* base);
void tolua_function (char* parent, char* name, lua_CFunction func);
void tolua_constant (char* parent, char* name, double value);
void tolua_tablevar
(char* table, char* name, lua_CFunction get, lua_CFunction set);
void tolua_tablearray
(char* table, char* name, lua_CFunction get, lua_CFunction set);


/* Get and push functions */
double tolua_getnumber (int narg, double def);
char* tolua_getstring (int narg, const char* def);
void* tolua_getuserdata (int narg, const void* def);
void* tolua_getusertype (int narg, const void* def);
lua_Object tolua_getobject (int narg, lua_Object def);
double tolua_getfieldnumber (lua_Object lo, int index, double def);
char* tolua_getfieldstring (lua_Object lo, int index, const char* def);
void* tolua_getfielduserdata (lua_Object lo, int index, const void* def);
void* tolua_getfieldusertype (lua_Object lo, int index, const void* def);
lua_Object tolua_getfieldobject (lua_Object lo, int index, lua_Object def);

void tolua_pushnumber (double value);
void tolua_pushstring (const char* value);
void tolua_pushuserdata (const void* value);
void tolua_pushusertype (const void* value, int tag);
void tolua_pushobject (lua_Object lo);
void tolua_pushfieldnumber (lua_Object lo, int index, double v);
void tolua_pushfieldstring (lua_Object lo, int index, char* v);
void tolua_pushfielduserdata (lua_Object lo, int index, void* v);
void tolua_pushfieldusertype (lua_Object lo, int index, void* v, int tag);
void tolua_pushfieldobject (lua_Object lo, int index, lua_Object tf);


#define tolua_gettable tolua_getobject
#define tolua_getfieldtable tolua_getfieldobject
#define tolua_getfunction tolua_getobject
#define tolua_getfieldfunction tolua_getfieldobject
#define tolua_pushtable tolua_pushobject
#define tolua_pushfieldtable tolua_pushfieldobject
#define tolua_pushfunction tolua_pushobject
#define tolua_pushfieldfunction tolua_pushfieldobject

/* Type & tag manipulation */
void tolua_usertype (char* type);
void tolua_settag (char* type, int* tag);
int  tolua_istype (int narg, int tag, int dim);
int  tolua_arrayistype (int narg, int tag, int dim, int def);

int  tolua_isnoobj (int narg);

/* Tag method manipulation */
void* tolua_doclone (void* value, int tag);
void* tolua_copy (void* value, unsigned int size);

/* Error handling */
void tolua_error (char* msg);

/* Exported variables */
extern int tolua_tag_nil;
extern int tolua_tag_number;
extern int tolua_tag_string;
extern int tolua_tag_userdata;
extern int tolua_tag_table;
extern int tolua_tag_cfunction;
extern int tolua_tag_function;

#ifdef __cplusplus
}
#endif

#endif 

