/* tolua: register functions
** Support code for Lua bindings.
** Written by Waldemar Celes
** TeCGraf/PUC-Rio
** Jul 1998
** $Id: tolua_rg.c,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it. 
** The software provided hereunder is on an "as is" basis, and 
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications. 
*/

#include <stdio.h>

#include "tolua.h"
#include "tolua_tm.h"
#include "tolua_tt.h"


void tolua_globalvar (char* name, lua_CFunction get, lua_CFunction set)
{
 lua_Object lo = lua_createtable();
 lua_pushobject(lo);
 lua_pushstring(".get");
 lua_pushcfunction(get);
 lua_settable();
 if (set)
 {
  lua_pushobject(lo);
  lua_pushstring(".set");
  lua_pushcfunction(set);
  lua_settable();
 }
 lua_pushobject(lo);
 lua_setglobal(name);
 toluaI_tm_global(lo);
}

static void toluaI_const_global_array ()
{
 lua_error("value of const array cannot be changed");
}


void tolua_globalarray (char* name, lua_CFunction get, lua_CFunction set)
{
 int tag = lua_newtag();
 lua_Object lo = lua_createtable();
 lua_pushobject(lo);
 lua_settag(tag);
 
 lua_pushcfunction(get);
 lua_settagmethod(tag,"gettable"); 
 if (set)
  lua_pushcfunction(set);
 else
  lua_pushcfunction(toluaI_const_global_array);
 lua_settagmethod(tag,"settable");
 lua_pushobject(lo);
 lua_setglobal(name);
}

void tolua_tablevar 
(char* table, char* name, lua_CFunction get, lua_CFunction set)
{
 lua_pushobject(lua_getglobal(table));
 lua_pushstring(".get");
 lua_pushobject(lua_gettable());
 lua_pushstring(name);
 lua_pushcfunction(get);
 lua_settable();
 if (set)
 {
  lua_pushobject(lua_getglobal(table));
  lua_pushstring(".set");
  lua_pushobject(lua_gettable());
  lua_pushstring(name);
  lua_pushcfunction(set);
  lua_settable();
 }
}

static void toluaI_get_array (void)
{
 lua_Object t;
 void* self = tolua_getuserdata(1,0);
 char* field = tolua_getstring(2,0);

 if (!field)
  tolua_error("invalid 'field' in accessing array");
 if (!self)
 {
  static char msg[BUFSIZ];
  sprintf(msg,"invalid 'self' in accessing array '%s'",field);
  tolua_error(msg);
 }
 lua_pushobject(lua_getglobal(".tolua_itype"));
 lua_pushnumber(lua_tag(lua_getparam(1)));
 lua_pushobject(lua_getglobal(lua_getstring(lua_gettable())));
 lua_pushstring(".array");
 lua_pushobject(lua_gettable());
 lua_pushstring(field);
 t = lua_gettable();
 lua_pushobject(t);
 lua_pushstring(".self");
 lua_pushuserdata(self);
 lua_rawsettable();
 lua_pushobject(t);
}

static void toluaI_const_array ()
{
 lua_error("value of const field cannot be changed");
}

void tolua_tablearray
(char* table, char* name, lua_CFunction get, lua_CFunction set)
{
 int tag = lua_newtag();
 lua_Object tobj = lua_createtable();
 lua_pushobject(tobj);
 lua_settag(tag);
 lua_pushcfunction(get);
 lua_settagmethod(tag,"gettable");
 if (set)
  lua_pushcfunction(set);
 else
  lua_pushcfunction(toluaI_const_array);
 lua_settagmethod(tag,"settable");

 lua_pushobject(lua_getglobal(table));
 lua_pushstring(".array");
 lua_pushobject(lua_rawgettable());
 lua_pushstring(name);
 lua_pushobject(tobj);
 lua_settable();

 tolua_tablevar(table,name,toluaI_get_array,NULL);
}

void tolua_module (char* name)
{
 if (!lua_istable(lua_getglobal(name)))
 {
  lua_Object t = lua_createtable();
  lua_pushobject(t);
  lua_pushstring(".get");
  lua_pushobject(lua_createtable());
  lua_settable();
  lua_pushobject(t);
  lua_pushstring(".set");
  lua_pushobject(lua_createtable());
  lua_settable();
  lua_pushobject(t);
  lua_setglobal(name);
  toluaI_tm_module(t);
 }
}

void tolua_cclass (char* name, char* base)
{
 lua_Object t = lua_createtable();
 lua_pushobject(t);
 lua_pushobject(t);
 lua_pushstring(".get");
 lua_pushobject(lua_createtable());
 lua_settable();
 lua_pushobject(t);
 lua_pushstring(".set");
 lua_pushobject(lua_createtable());
 lua_settable();
 lua_pushobject(t);
 lua_pushstring(".array");
 lua_pushobject(lua_createtable());
 lua_settable();
 lua_pushobject(t);
 lua_setglobal(name);
 toluaI_tm_class(t,name);
 toluaI_tt_class(t,name,base);
 if (*base != 0)
 {
  lua_pushobject(t);
  lua_pushstring(".base");
  lua_pushobject(lua_getglobal(base));
  lua_rawsettable();
 }
}


void tolua_function (char* parent, char* name, lua_CFunction func)
{
 if (parent==NULL)
 {
  lua_pushcfunction(func);
  lua_setglobal(name);
 }
 else
 {
  lua_pushobject(lua_getglobal(parent));
  lua_pushstring(name);
  lua_pushcfunction(func);
  lua_settable();
 }
}

void tolua_constant (char* parent, char* name, double value)
{
 if (parent)
 {
  lua_pushobject(lua_getglobal(parent));
  lua_pushstring(name);
  lua_pushnumber(value);
  lua_settable();
 }
 else
 {
  lua_pushnumber(value);
  lua_setglobal(name);
 }
}
