#ifndef COIN_SOCONTEXTHANDLER_H
#define COIN_SOCONTEXTHANDLER_H

#include <Inventor/SbBasic.h>

/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

// FIXME: when making this into a public class (to let the So*
// libraries notify about the destruction of a GL context), remember
// to add the COIN_DLL_API keyword. 20020813 mortene.

class SoContextHandler {
public:
  static void destructingContext(uint32_t contextid);

  typedef void ContextDestructionCB(uint32_t contextid, void * userdata);
  static void addContextDestructionCallback(ContextDestructionCB * func, void * closure);
  static void removeContextDestructionCallback(ContextDestructionCB * func, void * closure);
};

#endif // !COIN_SOCONTEXTHANDLER_H
