Unit Token ;
 // Thomas Scheffczyk <SCHEFFCZYK@islay.verwaltung.uni-mainz.de>
 //  I don't know if this will help you, but the following (simple) functions
 // helped me handling substrings. Perhaps you can use them to seperate the
 // text for each field (for i := 1 to NumToken do ...) and store it
 // seperatly in the database-fields.

// --------------------------------------------------------------------------------

interface

function GetToken(aString, SepChar: String; TokenNum: Byte):String;
function NumToken(aString, SepChar: String):Byte;
// ajoute par Y.Ouvrard ( y.ouvrard@t3a.com ) la veille de Nol 1998
Procedure SetToken (
  var aString : String; const SepChar : String ; TokenNum : byte ; T : String );

implementation

function GetToken(aString, SepChar: String; TokenNum: Byte):String;
{
parameters: aString : the complete string
            SepChar : a single character used as separator 
                      between the substrings
            TokenNum: the number of the substring you want
result    : the substring or an empty string if the are less then
            'TokenNum' substrings
}
var
   Token     : String;
   StrLen    : Byte;
   TNum      : Byte;
   TEnd      : Byte;

begin
     StrLen := Length(aString);
     TNum   := 1;
     TEnd   := StrLen;
     while ((TNum <= TokenNum) and (TEnd <> 0)) do
     begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               Token := Copy(aString,1,TEnd-1);
               Delete(aString,1,TEnd);
               Inc(TNum);
          end
          else
          begin
               Token := aString;
          end;
     end;
     if TNum >= TokenNum then
     begin
          // GetToken1 := Token; chang
          Result := Token;
     end
     else
     begin
          // GetToken1 := ''; chang
          Result := '';
     end;
end;

function NumToken(aString, SepChar: String):Byte;
{
parameters: aString : the complete string
            SepChar : a single character used as separator 
                      between the substrings
result    : the number of substrings
}

var
   RChar     : Char;
   StrLen    : Byte;
   TNum      : Byte;
   TEnd      : Byte;

begin
     if SepChar = '#' then
     begin
          RChar := '*'
     end
     else
     begin
         RChar := '#'
     end;
     StrLen := Length(aString);
     TNum   := 0;
     TEnd   := StrLen;
     while TEnd <> 0 do
     begin
          Inc(TNum);
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               aString[TEnd] := RChar;
          end;
     end;
     // NumToken1 := TNum; chang
     Result := TNum;
end;

// ajoute par Y.Ouvrard ( y.ouvrard@collatinus.org ) la veille de Nol 1998

Procedure SetToken (
  var aString : String; const SepChar :
  String ; TokenNum : byte ; T : String );
var
  p, i : integer;
  trouves : integer;
  longueur : integer;
  begin
    p := 1;
    trouves := 1;
    longueur := length(aString );
    While (p < longueur) and (trouves < TokenNum) do
      begin
        if aString[p] = SepChar then inc ( trouves ) ;
        inc ( p );
      end;
    if trouves < TokenNum then
      begin
        for i := 0 to TokenNum - trouves - 1 do
          aString := aString + SepChar;
        aString := aString + T;
      end
      else
      begin
        // remplacer le token
        while (p <= length(aString)) and (aString[p] <> SepChar)
          do System.Delete(aString, p, 1 );
        System.Insert(T, aString, p);
      end;
  end;

end.
