unit utiles;
{Collatinus - Extraction du lexique d'un texte latin.

Copyright (C) 1998 Y. Ouvrard.

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le
modifier conformment aux dispositions de la Licence Publique Gnrale GNU,
telle que publie par la Free Software Foundation ; version 2 de la licence,
ou encore ( votre choix) toute version ultrieure.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE
GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION
A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .
Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme
temps que ce programme ; si ce n'est pas le cas, crivez  la
Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
Pour tout contact avec l'auteur : yves.ouvrard@collatinus.org }

interface
uses Classes;

Const                 
  // chiffres = ['0'..'9'] ;
  majuscules = ['A'..'Z'];
  minuscules = ['a'..'z'];
  lettres = majuscules+minuscules; // + chiffres ?

  virgule = ',';
  ponctint = [virgule, ';', ':'];
  ponctphr = ['.', '!', '?'];
  ponct = ponctint+ponctphr;

  entree : char = #13;
  ret = #13#10;
  marge1 = '  ';
  marge2 = '    ';

  sansnom = 'SineNomine';
  
  {version linux : chemin des donnes}
  const
  share = '/usr/share/collatinus/';

Function VJversUI(C : String) : String;

function PremierMot( C : String) : String;

function array2stringlist(A : Array of string) : TStringList;
// gnre une StringList  partir de A

function in_array(C : string; A : Array of String) : integer;
// donne l'index de C dans A

Function Ultima(C : String) : Char;

Function Trime(C : string ; ponct : boolean) : string;

Function homeoRadical(Clong, Cbref : string) : string;

Function Homeoteleute(Clong, Cbref : string) : string;

Function ADroite(sep : char; L : string) : String;

Function AGauche(sep : char; L : string) : String;

Function ChangeDes(M, D1, D2 : String) : String;

Procedure simplifie(L : TStringList);

Function suffixee(M : string) : string;

Function RienDans(C : String) : Boolean;

Function Rebours(C : String) : string;

Function CoupeAGauche( sep : Char ; L : String) : String;

// Function CategorieDe(M : integer) : integer;

function rrggbb(C : integer) : string;
// convertit une couleur Delphi en couleur HTML

Function Corrige(N : integer) : integer;

Function RetroCorrige(N : integer) : integer;

implementation
uses SysUtils;

Function VJversUI(C : String) : String;
var i : integer;
Begin
for i := 1 to length(C) do
  begin
  if C[i] = 'v' then C[i] := 'u';
  if C[i] = 'j' then C[i] := 'i';
  end;
Result := C;
end;

function PremierMot( C : String) : String;
var i : integer;
begin
result := '';
i := 1;
C := trim(C);
while (i < length(C)) and (C[i] in lettres) do
   begin
      result := result + C[i];
      inc(i);
   end;
end;

function array2stringlist(A : Array of string) : TStringList;
   var i : integer;
begin
  result := TStringList.Create;
  for i := low(A) to high(A)
     do result.Add(A[i]);
end;

function in_array(C : string; A : Array of String) : integer;
var i : integer;
begin
result := - 1;
for i := low(A) to High(A) do
   if A[i] = C then
      begin
         result := i;
         break;
      end;
end;

Function Ultima(C : String) : Char;
Begin
Result := C[length(C)];
end;


Function Trime(C : string ; ponct : boolean) : string;
var signes : set of char;
Begin
Result := C;
if ponct then signes := lettres + [',', '!', '?', '.', ';']
else signes := lettres ;
While (length(Result) > 0) and
  not(Result[1] in signes) do delete(Result, 1,1);
While (length(Result) > 0) and
  not (Result[length(Result)] in signes) do
  delete(Result, length(Result), 1);
end;

Function HomeoRadical(Clong, Cbref : string) : string;
// donne le radical du mot Clong sans sa dsinence Cbref
Begin
result := '';
if Cbref = '' then exit;
if copy(CLong, length(Clong)-length(Cbref)+1, length(Clong)) = Cbref
  then result := copy(Clong, 1, length(Clong)-length(Cbref));
end;

Function Homeoteleute(Clong, Cbref : string) : string;
Begin
result := '';
if Cbref = '' then exit;
if Copy(CLong, length(Clong)-length(Cbref)+1, length(Clong)) = Cbref
  then result := Cbref;
end;


Function ADroite(sep : char ; L : string) : String;
var p : integer;
Begin
{
P := Pos(sep, L)+1;
if P > 0 then Result := Copy(L, P, length(L))
  else Result := '';}
result := '';
p := pos(sep, L);
While p > 0 do
  begin
  delete(L, 1, p); 
  result := L;
  p := pos(sep, L);
  end;
End;

Function AGauche(sep : char ; L : String) : String;
var p : integer;
Begin
P := Pos(sep, L);
if P > 0 then Result := Copy(L, 1, P-1)
  else Result := '';
End;

Function ChangeDes(M, D1, D2 : String) : String;
Begin
Result := HomeoRadical(M, D1);
Result := Result+D2;
end;

Procedure Simplifie(L : TStringList);
var i : integer;
    reference : integer;
Begin
if L.Count < 1 then exit;
// While rienDans(L[0]) do L.Delete(0);
reference := 0;
L.insert(0, L[0]);
i := 1;
while i < L.count do
  begin
  if agauche(#45, L[reference]) = agauche(#45, L[i]) then
    L[i] := #9+adroite(#45, L[i])
    else
    begin
    if i > reference+1 then
      L[reference]:= agauche('-', L[reference]);
    reference := i;
    end;
  inc(i);
  end;
if i > reference+1 then
  L[reference]:= agauche('-', L[reference]);
end;

Function suffixee(M : string) : string;
  Begin
  result := HomeoRadical(M, 'que');
  if result = '' then
    result := HomeoRadical(M, 'ue');
  if result = '' then
    result := HomeoRadical(M, 've');
  if result = '' then
    result := HomeoRadical(M, 'ne');
  end;

Function RienDans(C : String) : Boolean;
var i : integer;
Begin
result := true;
for i := 1 to length (C) do
  if C[i]in lettres then
  begin
  result := false;
  break;
  end;
end;

Function Rebours(C : String) : String;
var i : integer;
Begin
result := '';
for i := length(C) downto 1 do
  result := result + C[i];
end;

Function CoupeAGauche( sep : Char ; L : String) : String;
  begin
  result := copy(L, succ(pos(sep, L)), length(L));
  end;

function rrggbb(C : integer) : string;
  var rr, gg, bb : byte;
  Begin
    rr := C shr 16;
    gg := C shr 8 ;
    bb := C ;
    result := intToHex(bb, 2) + intToHex(gg, 2) + intToHex(rr, 2);
  end;

function Corrige(N : integer) : integer;
  Begin
  case N of
    0,2,7,14,21 : result := -1;
    1 : result := 0;
    3..6 : result := N-2;
    8..13 : result := N-3;
    15..20 : result := N-4;
    22..35 : result := N-5;
    else result := -1;
    end;
  end;

function RetroCorrige(N : integer) : integer;
  Begin
  case N of
    0 : result := 1;
    1..4 : result := N + 2;
    5..10 : result := N + 3;
    11..16 : result := N + 4;
    17..29 : result := N + 5;
    30 : result := 34;
    else result := 5;
    end;
  end;

end.
