/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File:	project.h
 * Author:	Joe English
 * Created:	Feb 1994
 * Description:	Useful macros used in Cost implementation.
 *
 * 1998/12/15 23:41:03
 * 1.6
 * 
 */


#ifndef _PROJECT_H
#define _PROJECT_H 1

/*+++ Tcl version-compatibility tests:
 */

/* We cannot free() the result of Tcl_SplitList() if we're running 
 * as a DLL under Windows (see 'Tcl on Windows FAQ', question C-3,
 * <URL: http://ourworld.compuserve.com:80/homepages/efjohnson/ >)
 * The solution is to call Tcl_Free, but that did not appear until Tcl 7.6.
 */
#if TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION <= 5
#define Tcl_FreeSplitList(p) Tcl_EventuallyFree((ClientData)(p), TCL_DYNAMIC)
#else
#define Tcl_FreeSplitList(p) Tcl_Free((VOID *)p)
#endif

/* I/O facilities: check for old-style (stdio-based) 
 * or new-style (Tcl_Channel-based).
 */
#if TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION <= 4
#define HAVE_TCL_CHANNEL_IO 0
#else
#define HAVE_TCL_CHANNEL_IO 1
#endif

/* Check if Tcl package facility is available:
 */
#if TCL_MAJOR_VERSION > 7 || TCL_MINOR_VERSION >= 5
#define HAVE_TCL_PACKAGES 1
#else
#define HAVE_TCL_PACKAGES 0
#endif
/*
 * Assertions: Run-time checking of invariant conditions.
 * Usage: ASSERT(test, message)
 * Assertions are only turned on if -DDEBUG is used.
 * Failed assertions print the message and abort().
 * This is different from the standard assert() in that
 * it is turned *off* by default, and the programmer
 * must supply a documentary message explaining the assertion.
 */

/* !!! Fix this... */
#if DEBUG
#	ifndef BUFSIZ
#		include <stdio.h>
#	endif
#    define ASSERT(test,message) 				\
	if (!(test)) {						\
	    fprintf(stderr,"Assertion failed: %s line %d\n%s",		\
		__FILE__, __LINE__, message);			\
	    abort();						\
	}
#else
#    define ASSERT(test,message)
#endif

#if DBMALLOC
#	include "dbmalloc.h"
#endif

/* STOMP value is used for debugging purposes;
 * freed pointers may be set to STOMP (0x1) 
 * so any future use will crash the program sooner rather than later.
 */
#ifndef STOMP
#	define STOMP ((void *)0x1)
#endif
#ifndef STOMPON
#    if DEBUG
#	define STOMPON(p) (p)=((void *)0x1);
#    else
#	define STOMPON(p)
#    endif
#endif

#endif		/* _PROJECT_H	*/
