/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File:	stream.c
 * Author: 	Joe English
 * Created:	25 Feb 1995
 * Description: Routines to manage ESISInputStreams
 * Purpose:	This is basically here so that rdsgmls.c
 *		doesn't need to know about Tcl I/O.
 *
 * 1998/11/20 03:48:58
 * 1.8
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include "project.h"
#include "strmap.h"
#include "pile.h"
#include "esis.h"
#include "esisp.h"

ESISInputStream estream_create(ESISIOproc buffill, void *bufclosure)
{
    ESISInputStream stream = malloc(sizeof(*stream));
    if (!stream) return NULL;

    stream->bufsize = BUFSIZ;
    stream->buf = malloc(stream->bufsize);
    if (!stream->buf) { free(stream); return 0; }
    stream->bufp = stream->buf;
    stream->bufcnt = 0;
    stream->buffill = buffill;
    stream->bufclosure = bufclosure;

    return stream;
}

void estream_close(ESISInputStream stream)
{
    if (stream->buf) 	free(stream->buf);
    free(stream);
}

int ESIS_fillbuf(ESISInputStream stream)
{
    stream->bufcnt = 
	stream->buffill(stream->bufclosure, stream->buf, stream->bufsize); 
    stream->bufp = stream->buf;
    if (stream->bufcnt > 0) {
	--stream->bufcnt;
	return *stream->bufp++;
    } else {
	stream->bufcnt = 0;
	return -1;
    }
}

/*+++ I/O proc for stdio:
*/
int ESISIOstdio(void *closure, char *buf, int n)
{
     FILE *fp = (FILE *)closure;
     return fread(buf, sizeof(char), n, fp);
}

/*EOF*/
