/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"moduledel.h"
#include	"courier.h"
#include	"maxlongsize.h"
#include	"waitlib/waitlib.h"
#include	<stdlib.h>
#include	<stdio.h>
#include	<errno.h>
#include	<signal.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

static char *linebuf=0;
static size_t linebufsize=0;
static char **cols=0;
static size_t colcnt=0;

char	**module_parsecols(char *p)
{
unsigned l;
size_t	ncols=1;
size_t	n;

	for (l=0; p[l]; l++)
		if (p[l] == '\t')	++ncols;

	if (ncols >= colcnt)
	{
		colcnt=ncols+10;
		cols=(char **)(cols ? realloc(cols, colcnt*sizeof(char *))
				: malloc(colcnt*sizeof(char *)));
	}
	ncols=1;
	cols[0]=linebuf;
	for (n=0; p[n]; n++)
		if (p[n] == '\t')
			cols[ncols++]=p+n+1;
	cols[ncols]=0;
	if (ncols < 6)	return (0);
	return (cols);
}

struct moduledel *module_parsedel(char **cols)
{
size_t	n;
const char *cp;
static struct moduledel msginfo;

	for (n=1; cols[n]; n++)
		cols[n][-1]=0;

	cp=cols[0];
	msginfo.inum=0;
	while (*cp >= '0' && *cp <= '9')
		msginfo.inum = msginfo.inum*10 + (*cp++ - '0');
	msginfo.msgid=cols[1];

	msginfo.sender=cols[2];
	msginfo.delid=cols[3];
	msginfo.host=cols[4];
	msginfo.receipients=&cols[5];
	msginfo.nreceipients=(n - 5)/2;
	return (&msginfo);
}

char *module_getline( int (*get_func)(void *), void *ptr)
{
size_t	n;
int	c;

	for (n=0; ; n++)
	{
		do
		{
			errno=0;
			c= (*get_func)(ptr);
		} while (c == EOF && errno == EINTR);

		if (n >= linebufsize)
		{
			if ((linebuf=(char *)
				(linebufsize ? realloc(linebuf,
					linebufsize += 256):
					malloc(linebufsize += 256))) == 0)
				clog_msg_errno();
		}

		if (c == '\n' || c == EOF)	break;

		linebuf[n]=c;
	}
	linebuf[n]=0;
	if (c == EOF && n == 0)	return (0);
	return (linebuf);
}

static int get_stdin(void *dummy)
{
	return (getchar());
}

struct moduledel *module_getdel()
{
char	**cols;
char	*line=module_getline( &get_stdin, 0);

	if (!line)	return (0);

	if ((cols=module_parsecols(linebuf)) == 0)	return (0);
	return (module_parsedel(cols));
}

void module_completed(unsigned i, unsigned n)
{
char	buf[MAXLONGSIZE+1];
char	*p;
unsigned c;

	i=i;
	p=buf+MAXLONGSIZE-1;
	*p='\n';
	p[1]=0;
	c=1;
	do
	{
		*--p= (n % 10) + '0';
		++c;
	} while ((n=n / 10) != 0);
	write (1, p, c);
}

unsigned module_nchildren;
unsigned *module_delids;
pid_t *module_pids;
static void (*childfunc)(unsigned, unsigned);

static void terminated(pid_t p, int s)
{
int	n;

	for (n=0; n<module_nchildren; n++)
		if (module_pids[n] == p)
		{
			module_pids[n]= -1;
			(*childfunc)(n, module_delids[n]);
			break;
		}
}

static RETSIGTYPE childsig(int);

void module_blockset()
{
	wait_block();
}

void module_blockclr()
{
	wait_clear(childsig);
}

void module_restore()
{
	wait_restore();
}

static RETSIGTYPE childsig(int n)
{
	n=n;

	wait_reap(terminated, childsig);

#if	RETSIGTYPE != void
	return (0);
#endif
}

void module_init(void (*func)(unsigned, unsigned))
{
const	char *p=getenv("MAXDELS");
unsigned n;

	if (!p)	p="0";

	if (!func)
		func= &module_completed;

	module_nchildren=atol(p);
	if (module_nchildren <= 0)	module_nchildren=1;

	if ((module_pids=malloc(module_nchildren*sizeof(*module_pids))) == 0 ||
		(module_delids=malloc(module_nchildren*sizeof(*module_delids))) == 0)
		clog_msg_errno();

	for (n=0; n<module_nchildren; n++)
		module_pids[n]= -1;

	childfunc=func;
	signal(SIGCHLD, childsig);
}

static pid_t module_fork_common(unsigned delid, unsigned *slotptr,
	int dorelease)
{
pid_t	pid;
unsigned n;
static unsigned idx=0;

	if (slotptr)
		idx= *slotptr;
	else
	{
		for (n=0; n<module_nchildren; n++)
		{
			if (module_pids[idx] < 0)	break;
			if (++idx >= module_nchildren)	idx=0;
		}

		if (n == module_nchildren)
		{
			clog_msg_start_err();
			clog_msg_str(
			"Internal error - no available process slots.");
			clog_msg_send();
			exit(1);
		}
	}

	if ((pid=fork()) == -1)
		return (pid);

	if (pid)
	{
		module_pids[idx]=pid;
		module_delids[idx]=delid;
	}
	else
	{
		module_restore();
	}

	return (pid);
}

pid_t module_fork_noblock(unsigned delid, unsigned *slotptr)
{
	return (module_fork_common(delid, slotptr, 0));
}

pid_t module_fork(unsigned delid, unsigned *slotptr)
{
pid_t	pid;

	module_blockset();

	pid=module_fork_common(delid, slotptr, 1);

	if (pid)
		module_blockclr();
	return (pid);
}
